﻿using UnityEngine;
using System.Collections;

public class MainMenuLight : MonoBehaviour
{
    public AnimationCurve m_LightingCurve;
    private Timer m_Timer;

    public void SwitchOff(float duration)
    {
        m_Timer = new Timer(duration);
        m_Timer.Start();
        StartCoroutine("C_SwitchOff");
    }

    private IEnumerator C_SwitchOff()
    {
        while (!m_Timer.UpdateTime())
        {
            light.color = Color.Lerp(Color.white, Color.black, m_LightingCurve.Evaluate(m_Timer.Progress()));
            yield return 0;
        }

        light.color = Color.black;
    }
}