﻿using UnityEngine;
using System.Collections;

public class MainMenuCam : MonoBehaviour
{
    private Transform m_Transform;

    public Transform m_Target;
    private Vector3 m_TargetPos;
    public Transform[] m_Spots;
    private Vector3[] m_SpotsPos;

    private Timer m_Timer;
    private int m_CurrentSpot;
    private int m_NextSpot;
    private int m_NbSpots;

    private bool m_Move;

	void Start()
    {
        m_Transform = transform;

        m_TargetPos = m_Target.position;
        m_NbSpots = m_Spots.Length;
        m_SpotsPos = new Vector3[m_NbSpots];
        for (int i = 0; i < m_NbSpots; ++i)
        {
            m_SpotsPos[i] = m_Spots[i].position;
        }

        m_CurrentSpot = 0;
        m_NextSpot = 1 % m_NbSpots;
        m_Timer = new Timer(3f);
        m_Timer.Start();
        m_Move = true;
	}

	void Update()
    {
        if (!m_Move)
            return;

        if(m_Timer.UpdateTime())
        {
            m_CurrentSpot = (m_CurrentSpot + 1) % m_NbSpots;
            m_NextSpot = (m_CurrentSpot + 1) % m_NbSpots;
            m_Timer.Restart();
        }

        m_Transform.position = Vector3.Lerp(m_SpotsPos[m_CurrentSpot], m_SpotsPos[m_NextSpot], m_Timer.GetHermiteProgress());
        m_Transform.LookAt(m_TargetPos);
	}

    public void StopMoving()
    {
        m_Move = false;
    }
}