﻿using UnityEngine;
using System;
using System.IO;
using System.Xml;
using System.Collections;
using System.Collections.Generic;

public class SaveManager
{
    private ProgressData m_ProgressData;

    public SaveManager(ProgressData pd)
    {
        m_ProgressData = pd;
    }

    #region Save
    public void Save()
    {
#if UNITY_STANDALONE
        XmlDocument document = new XmlDocument();

        // Create root node
        XmlElement root = document.CreateElement("Virus");
        document.AppendChild(root);
        // Create Levels node
        {
            XmlElement levelsNode = document.CreateElement("Levels");

            // Get levels data array
            int size = 0;
            ProgressData.LevelData[] levelsData = m_ProgressData.GetLevelsData(out size);

            // Each level
            for (int i = 0; i < size; ++i)
            {
                // Create level node
                XmlElement level = document.CreateElement("Level");
                level.SetAttribute("nameID", ((int)levelsData[i].LevelName).ToString());
                level.SetAttribute("current", (m_ProgressData.CurrentLevelName == levelsData[i].LevelName).ToString());
                level.SetAttribute("finished", levelsData[i].Finished.ToString());
                level.SetAttribute("bestTime", levelsData[i].BestTime.ToString());
                level.SetAttribute("bestScore", levelsData[i].BestScore.ToString());
                if (m_ProgressData.CurrentLevelName == levelsData[i].LevelName)
                {
                    //Debug.Log("Current score : " + m_ProgressData.RegisteredCurrentLevelScore);
                    level.SetAttribute("currentTime", m_ProgressData.CurrentLevelTime.ToString());
                    level.SetAttribute("currentScore", m_ProgressData.RegisteredCurrentLevelScore.ToString());
                }
                else
                {
                    level.SetAttribute("currentTime", "0");
                    level.SetAttribute("currentScore", "0");
                }

                // Create Checkpoints node
                {
                    XmlElement checkpointsNode = document.CreateElement("Checkpoints");

                    // Each checkpoint
                    foreach (ProgressData.CheckpointData cpData in levelsData[i].Checkpoints)
                    {
                        XmlElement checkpoint = document.CreateElement("Checkpoint");
                        checkpoint.SetAttribute("order", cpData.Order.ToString());
                        // The checkpoint is the current if it has got the good order AND if the level is the current one TOO !
                        checkpoint.SetAttribute("current", ((m_ProgressData.CurrentLevelName == levelsData[i].LevelName) && (m_ProgressData.CurrentCheckPointOrder == cpData.Order)).ToString());
                        // The checkpoint is the current if it has got the good order AND if the level is the current one TOO !
                        checkpoint.SetAttribute("last", ((m_ProgressData.CurrentLevelName == levelsData[i].LevelName) && (m_ProgressData.LastCheckPointOrder == cpData.Order)).ToString());

                        // Items
                        {
                            XmlElement items = document.CreateElement("Items");
                            string tmp = "";
                            int nbItems = cpData.CollectedItems.Count;
                            if (cpData.CollectedItems != null && nbItems > 0)
                            {
                                for (int item = 0; item < nbItems; ++item)
                                {
                                    tmp += cpData.CollectedItems[item];
                                    if (item + 1 < nbItems)
                                    {
                                        tmp += "|";
                                    }
                                }
                            }

                            XmlText scoreText = document.CreateTextNode(tmp);
                            items.AppendChild(scoreText);

                            // Add the Items node as child of Checkpoint node
                            checkpoint.AppendChild(items);
                        }

                        // Add the Checkpoint node as child of Checkpoints node
                        checkpointsNode.AppendChild(checkpoint);
                    }

                    // Add the Checkpoints node as child of Level node
                    level.AppendChild(checkpointsNode);
                }

                // Add the Level node as child of Levels node
                levelsNode.AppendChild(level);
            }

            // Add the Levels node as child of Virus node
            root.AppendChild(levelsNode);
        }

        // Create Data node
        {
            XmlElement dataNode = document.CreateElement("Data");

            // Create score node
            {
                XmlElement score = document.CreateElement("Score");
                score.SetAttribute("value", m_ProgressData.RegisteredScore.ToString());

                // Add the Score node as child of Data node
                dataNode.AppendChild(score);
            }

            // Create time node
            {
                XmlElement time = document.CreateElement("Time");
                // TODO : Set correct value
                time.SetAttribute("value", m_ProgressData.PlayTime.ToString());

                // Add the Score node as child of Data node
                dataNode.AppendChild(time);
            }

            // Add the Data node as child of Virus node
            root.AppendChild(dataNode);
        }

        document.Save(GetSavePath());
#elif UNITY_WEBPLAYER
        // Global
        // => Score
        PlayerPrefs.SetInt("Score", m_ProgressData.RegisteredScore);
        // => Time
        PlayerPrefs.SetInt("Time", m_ProgressData.PlayTime);

        // Current
        // => Current level
        PlayerPrefs.SetInt("CurrentLevel", (int)m_ProgressData.CurrentLevelName);
        // => Current checkpoint
        PlayerPrefs.SetInt("CurrentCheckpoint", m_ProgressData.CurrentCheckPointOrder);
        // => Last checkpoint
        PlayerPrefs.SetInt("LastCheckPoint", m_ProgressData.LastCheckPointOrder);
        // => Current level score
        PlayerPrefs.SetInt("CurrentLevelScore", m_ProgressData.RegisteredCurrentLevelScore);
        // => Current level time
        PlayerPrefs.SetInt("CurrentLevelTime", m_ProgressData.CurrentLevelTime);

        // Best
        int size = 0;
        ProgressData.LevelData[] levelsData = m_ProgressData.GetLevelsData(out size);
        // Each level
        for (int i = 0; i < size; ++i)
        {
            if (levelsData[i].Finished)
            {
                PlayerPrefs.SetInt("Finished" + (int)levelsData[i].LevelName, 1);
                Debug.Log(levelsData[i].LevelName.ToString());
            }
            else PlayerPrefs.SetInt("Finished" + (int)levelsData[i].LevelName, 0);
            PlayerPrefs.SetInt("BestScore" + (int)levelsData[i].LevelName, levelsData[i].BestScore);
            PlayerPrefs.SetInt("BestTime" + (int)levelsData[i].LevelName, levelsData[i].BestTime);

            // Each checkpoint
            foreach (ProgressData.CheckpointData cpData in levelsData[i].Checkpoints)
            {
                string tmp = "";
                int nbItems = cpData.CollectedItems.Count;
                if (nbItems > 0)
                {
                    for (int item = 0; item < nbItems; ++item)
                    {
                        tmp += cpData.CollectedItems[item];
                        if (item + 1 < nbItems)
                        {
                            tmp += "|";
                        }
                    }
                }

                PlayerPrefs.SetString("Item-" + i + "-" + cpData.Order, tmp);
            }
        }

        // Game finished
        bool gameFinished = true;
        foreach(ProgressData.LevelData lvlData in levelsData)
        {
            if(!lvlData.Finished) gameFinished = false;
        }
        if (gameFinished) PlayerPrefs.SetInt("GameFinished", 1);
        else PlayerPrefs.SetInt("GameFinished", 0);
#endif
    }
    #endregion

    #region Load
    public void Load()
    {
        m_ProgressData.Initialize();

#if UNITY_STANDALONE
        // Check if the emplacement has got a save
        FileStream saveFile = new FileStream(GetSavePath(), FileMode.OpenOrCreate, FileAccess.Read);
        if (saveFile.Length > 0)
        {
            try
            {
                // Create xml reader
                XmlDocument document = new XmlDocument();
                document.Load(saveFile);
                // Get root node
                XmlNode root = document.DocumentElement;
                // -> Get Levels parent node
                XmlNode levelsNode = root.SelectSingleNode("Levels");
                // -> Check each level
                ProgressData.LevelData[] levelsData = new ProgressData.LevelData[levelsNode.ChildNodes.Count];
                int iLevel = 0;
                foreach (XmlNode level in levelsNode.ChildNodes)
                {
                    // Get level name
                    levelsData[iLevel].LevelName = (LevelSettings.LevelName)int.Parse(level.Attributes["nameID"].InnerText);
                    // This level is finished ?
                    levelsData[iLevel].Finished = bool.Parse(level.Attributes["finished"].InnerText);
                    // The best time
                    levelsData[iLevel].BestTime = int.Parse(level.Attributes["bestTime"].InnerText);
                    // The best score
                    levelsData[iLevel].BestScore = int.Parse(level.Attributes["bestScore"].InnerText);
                    // This level is the current one ?
                    if (bool.Parse(level.Attributes["current"].InnerText))
                    {
                        m_ProgressData.SetCurrentLevelName(levelsData[iLevel].LevelName);
                        m_ProgressData.InitializeCurrentLevelTime(int.Parse(level.Attributes["currentTime"].InnerText));
                        m_ProgressData.InitializeCurrentLevelScore(int.Parse(level.Attributes["currentScore"].InnerText));
                    }
                    // Get checkpoints parent node
                    XmlNode checkpointsNode = level.SelectSingleNode("Checkpoints");
                    // Check each checkpoint
                    ProgressData.CheckpointData[] checkpointsData = new ProgressData.CheckpointData[checkpointsNode.ChildNodes.Count];
                    int iCheckpoint = 0;
                    foreach (XmlNode checkpoint in checkpointsNode.ChildNodes)
                    {
                        // Get order
                        checkpointsData[iCheckpoint].Order = int.Parse(checkpoint.Attributes["order"].InnerText);
                        // This checkpoint is the current one ?
                        if (bool.Parse(checkpoint.Attributes["current"].InnerText)) m_ProgressData.SetCurrentCheckPoint(checkpointsData[iCheckpoint].Order);
                        // Is it the last one ?
                        if (bool.Parse(checkpoint.Attributes["last"].InnerText)) m_ProgressData.SetLastCheckPoint(checkpointsData[iCheckpoint].Order);
                        // Get items status
                        List<int> items = new List<int>();
                        XmlNode itemsNode = checkpoint.SelectSingleNode("Items");
                        if(itemsNode != null)
                        {
                            string tmp = itemsNode.InnerText;
                            string[] tmp2 = tmp.Split('|');
                            foreach (string i in tmp2)
                            {
                                int id;
                                if (int.TryParse(i, out id))
                                {
                                    items.Add(id);
                                }
                            }
                        }
                        checkpointsData[iCheckpoint].CollectedItems = items;

                        iCheckpoint++;
                    }

                    levelsData[iLevel].Checkpoints = checkpointsData;
                    iLevel++;
                }

                m_ProgressData.SetLevelsData(levelsData);

                // -> Get Score node
                XmlNode scoreNode = root.SelectSingleNode("Data/Score");
                m_ProgressData.InitializeScore(int.Parse(scoreNode.Attributes["value"].InnerText));

                // -> Get Time node
                XmlNode timeNode = root.SelectSingleNode("Data/Time");
                m_ProgressData.InitializePlayTime(int.Parse(timeNode.Attributes["value"].InnerText));
            }
            catch (Exception e)
            {
                Debug.LogError("Can't load the game : " + e.Message);
            }
            saveFile.Close();
        }
        else
        {
            saveFile.Close();
            //Debug.Log("No save -> new game");
            CreateGame();
        }
#elif UNITY_WEBPLAYER
        // Global
        // Score
        m_ProgressData.InitializeScore(PlayerPrefs.GetInt("Score"));
        // Time
        m_ProgressData.InitializePlayTime(PlayerPrefs.GetInt("Time"));

        // Current
        // Current Level
        m_ProgressData.SetCurrentLevelName((LevelSettings.LevelName)PlayerPrefs.GetInt("CurrentLevel"));
        // Current checkpoint
        m_ProgressData.SetCurrentCheckPoint(PlayerPrefs.GetInt("CurrentCheckpoint"));
        // Last checkpoint
        m_ProgressData.SetLastCheckPoint(PlayerPrefs.GetInt("LastCheckPoint"));
        // Current level score
        m_ProgressData.InitializeCurrentLevelScore(PlayerPrefs.GetInt("CurrentLevelScore"));
        // Current level time
        m_ProgressData.InitializeCurrentLevelTime(PlayerPrefs.GetInt("CurrentLevelTime"));

        // Best
        int size = Enum.GetNames(typeof(LevelSettings.LevelName)).Length;
        ProgressData.LevelData[] levelsData = new ProgressData.LevelData[size];
        // Each level
        for(int i = 0; i<size; ++i)
        {
            levelsData[i].LevelName = (LevelSettings.LevelName)i;
            levelsData[i].BestScore = PlayerPrefs.GetInt("BestScore" + i);
            levelsData[i].BestTime = PlayerPrefs.GetInt("BestTime" + i);
            if (PlayerPrefs.GetInt("Finished" + i) == 1) levelsData[i].Finished = true;
            else levelsData[i].Finished = false;

            // Each checkpoint
            int nbCheckpoints = LevelSettings.NbCheckpoints[i];
            ProgressData.CheckpointData[] checkpointsData = new ProgressData.CheckpointData[nbCheckpoints];
            // Get items status
            for(int j=0; j<nbCheckpoints; ++j)
            {
                List<int> items = new List<int>();
                string tmp = PlayerPrefs.GetString("Item-" + i + "-" + j);
                string[] tmp2 = tmp.Split('|');
                foreach (string s in tmp2)
                {
                    int id;
                    if (int.TryParse(s, out id))
                    {
                        items.Add(id);
                    }
                }
                checkpointsData[j].CollectedItems = items;
            }
            levelsData[i].Checkpoints = checkpointsData;
        }

        m_ProgressData.SetLevelsData(levelsData);
#endif
    }
    #endregion

    #region Game management
    public void CreateGame()
    {
#if UNITY_WEBPLAYER
        PlayerPrefs.DeleteAll();
#endif
        m_ProgressData.Initialize();
    }

    public void DeleteGame()
    {
#if UNITY_STANDALONE
        FileStream saveFile = new FileStream(GetSavePath(), FileMode.Truncate, FileAccess.Write);
        saveFile.Close();
#elif UNITY_WEBPLAYER

#endif
    }
    #endregion

#if UNITY_STANDALONE
    private string GetSavePath()
    {
        return (Application.dataPath + "/Save.xml");
    }
#endif
}