using UnityEngine;
using System.Collections;

public class Key
{
	// Key name
	private string m_Name;
	public string Name
	{
		get { return m_Name; }
		set { m_Name = value; }
	}
	// Keycode
	private KeyCode m_KeyId;
	public KeyCode KeyId
	{
		get { return m_KeyId; }
		set { m_KeyId = value; }
	}
	
	#region Contructors
	public Key()
	{
		m_Name = null;
		m_KeyId = KeyCode.None;
	}
	
	public Key(string name)
	{
		m_Name = name;
		m_KeyId = KeyCode.None;
	}
	
	public Key(KeyCode keyCode)
	{
		m_Name = null;
		m_KeyId = keyCode;
	}
	#endregion
	
	#region Getters
	public bool GetKeyDown()
	{
		if(StringUtils.IsEmptyString(m_Name))
		{
			if(Input.GetKeyDown(m_KeyId))
			{
				return true;
			}
			
			return false;
		}
		else
		{
			// TODO : Si la touche utilise son nom comme identifiant (joysticks)
			return false;
		}
	}
	
	public bool GetKeyPressed()
	{
		if(StringUtils.IsEmptyString(m_Name))
		{
			if(Input.GetKey(m_KeyId))
			{
				return true;
			}
			
			return false;
		}
		else
		{
			// TODO : Si la touche utilise son nom comme identifiant (joysticks)
			return false;
		}
	}
	
	public bool GetKeyUp()
	{
		if(StringUtils.IsEmptyString(m_Name))
		{
			if(Input.GetKeyUp(m_KeyId))
			{
				return true;
			}
			
			return false;
		}
		else
		{
			// TODO : Si la touche utilise son nom comme identifiant (joysticks)
			return false;
		}
	}
	#endregion
}