using UnityEngine;
using System;
using System.Collections;
using System.Collections.Generic;

public class DeviceControllerKeyboard : DeviceController
{
	// Statics variables
	private static int s_IdNumber = 100000;
	private static int s_IdCounter = 0;
	
	// Config
	private DeviceControllerConfig m_Config;
	
	#region Contructors
	public DeviceControllerKeyboard(int id, string name, InputSettings.Devices type)
		:base(id,name,type)
	{
		// Initialize movements status list
		int taille = Enum.GetNames(typeof(InputSettings.Movements)).Length;
		m_MovementsStatus = new float[taille];
		for(int i=0; i<taille; ++i)
		{
			m_MovementsStatus[i] = 0f;
		}
		// Initialize actions status list
		taille = Enum.GetNames(typeof(InputSettings.Actions)).Length;
		m_ActionsStatus = new InputSettings.ActionStatus[taille];
		for(int i=0; i<taille; ++i)
		{
			m_ActionsStatus[i] = InputSettings.ActionStatus.Released;
		}
		// Initialize menu inputs status list
		taille = Enum.GetNames(typeof(InputSettings.MenuInputs)).Length;
		m_MenuStatus = new bool[taille];
		for(int i=0; i<taille; ++i)
		{
			m_MenuStatus[i] = false;
		}
		
		// Definition of inputs for 2D movements
		List<Axis> m_Movements2D = new List<Axis>();
		Key tmpKey1, tmpKey2;
		Axis tmpAxis;
		// Horizontal axis
		tmpKey1 = new Key(KeyCode.D);
		tmpKey2 = new Key(KeyCode.Q);
		tmpAxis = new Axis(tmpKey1,tmpKey2);
		m_Movements2D.Add(tmpAxis);
		// Vertical axis
		tmpKey1 = new Key(KeyCode.Z);
		tmpKey2 = new Key(KeyCode.S);
		tmpAxis = new Axis(tmpKey1,tmpKey2);
		m_Movements2D.Add(tmpAxis);
		
		// Definition of inputs for actions
		List<Key> m_Actions = new List<Key>();
		// Jump
		tmpKey1 = new Key(KeyCode.Space);
		m_Actions.Add(tmpKey1);
		// Attack
		tmpKey1 = new Key(KeyCode.Mouse0);
		m_Actions.Add(tmpKey1);
		// Corruption
		tmpKey1 = new Key(KeyCode.Mouse1);
		m_Actions.Add(tmpKey1);
        // Interaction
        tmpKey1 = new Key(KeyCode.E);
        m_Actions.Add(tmpKey1);
        // Sprint
        tmpKey1 = new Key(KeyCode.LeftShift);
        m_Actions.Add(tmpKey1);
		// Pause
		tmpKey1 = new Key(KeyCode.Escape);
		m_Actions.Add(tmpKey1);
		
		// Creation of the configuration (set default inputs)
		m_Config = new DeviceControllerConfig(m_Movements2D,m_Actions);
		
		// Set the time after which the device is considerred as used
		m_TimeToBeUsed = 0.1f;
	}
	#endregion
	
	#region Connection
	public static DeviceController Connection()
	{
		DeviceControllerKeyboard dck = new DeviceControllerKeyboard((s_IdNumber+s_IdCounter),"Keyboard",InputSettings.Devices.Keyboard);
		s_IdCounter++;
		
		return dck;
	}
	#endregion
	
	#region Movements
	// Getter
	public override float GetAxisValue(InputSettings.Movements axis)
	{
		return m_MovementsStatus[(int)axis];
	}
	
	// Setter
	public override void UpdateAxis()
	{
		bool used = m_Config.UpdateAxis(m_MovementsStatus);
		if(used) m_UsedThisFrame = true;
	}
	#endregion
	
	#region Actions
	// Getter
	public override bool GetActionStatus(InputSettings.Actions action, InputSettings.ActionStatus status)
	{
		return (m_ActionsStatus[(int)action] == status);
	}
	
	// Setter
	public override void UpdateActions()
	{
		bool used = m_Config.UpdateActions(m_ActionsStatus);
		if(used) m_UsedThisFrame = true;
	}
	#endregion
	
	#region Menu inputs
	// Getter
	public override bool GetMenuInputStatus(InputSettings.MenuInputs input)
	{
		return m_MenuStatus[(int)input];
	}
	
	// Setter
	public override void UpdateMenuInputs()
	{
		bool used = m_Config.UpdateMenuInputs(m_MenuStatus);
		if(used) m_UsedThisFrame = true;
	}
	#endregion
}