﻿using UnityEngine;
using System.Collections;

[System.Serializable]
public class MovableCameraZone : CameraZone
{
    // Camera zone
    public Vect4f m_CameraZone;
    public Vect4f CameraZone
    {
        get { return m_CameraZone; }
        set { m_CameraZone = value; }
    }

    // Distance
    public float m_Distance;
    public float Distance
    {
        get { return m_Distance; }
        set { m_Distance = value; }
    }

    // X axe
    public bool m_LockX;
    public bool LockX
    {
        get { return m_LockX; }
        set { m_LockX = value; }
    }
    public float m_ValueX;
    public float ValueX
    {
        get { return m_ValueX; }
        set { m_ValueX = value; }
    }

    // Y axe
    public bool m_LockY;
    public bool LockY
    {
        get { return m_LockY; }
        set { m_LockY = value; }
    }
    public float m_ValueY;
    public float ValueY
    {
        get { return m_ValueY; }
        set { m_ValueY = value; }
    }

    public MovableCameraZone(Vect4f charZone, Vect4f camZone)
        : base(charZone)
    {
        m_CameraZone = camZone;
    }

    public override void SetCameraSettings()
    {
        CameraManager.Instance.NewSettings(m_Distance,m_LockX,m_LockY,m_ValueX,m_ValueY);
    }
}