﻿using UnityEngine;
using System.Collections;

public class PhysicButton : InteractiveElement
{
    private Animator m_Animator;
    private bool m_AnimDone;

    private bool m_IsPushed;
    public bool IsPushed
    {
        get
        {
            if (m_IsPushed)
            {
                m_IsPushed = false;
                return true;
            }
            else return false;
        }
    }

    // 0 => Switch off, 1 => switch on/off, -1 => Nothing
    public int[] m_SetDiodeValue;
    public int[] SetDiodeValue
    {
        get { return m_SetDiodeValue; }
    }

    protected override void OnEnable()
    {
        base.OnEnable();
        m_Animator = GetComponent<Animator>();
        m_AnimDone = true;
    }

    protected override void Start()
    {
        base.Start();
    }

    public override bool UpdateElement()
    {
        if (!m_AnimDone)
            return base.UpdateElement();

        if (m_Used) Debug.Log(name + " used");

        if (m_Used && !m_Trigger.IsIn)
        {
            m_Used = false;
            StartCoroutine("C_Push");
        }

        if (!m_Used && m_Trigger.IsIn)
        {
            m_Used = true;
            StartCoroutine("C_Push");
        }

        return base.UpdateElement();
    }

    private IEnumerator C_Push()
    {
        m_AnimDone = false;
        if (m_Used)
        {
            m_Animator.SetBool("Push", true);
            m_IsPushed = true;
        }
        else m_Animator.SetBool("Unpush", true);
        yield return 0;

        if (m_Used) m_Animator.SetBool("Push", false);
        else m_Animator.SetBool("Unpush", false);
        yield return new WaitForSeconds(1f);

        m_AnimDone = true;
    }
}