﻿using UnityEngine;
using System.Collections;

public class Enemy : Character
{
    public int m_Level;
    public int m_Dammage;

    private Vector3 m_RegisteredPosition;
    protected EnemyRoutine m_Routine;

    public bool m_PlayImmediate = true;
    protected bool m_Activate;

    protected override void Start()
    {
        base.Start();
        m_Type = CharacterSettings.Type.Enemy;
        m_RegisteredPosition = transform.position;
        m_Routine = GetComponent<EnemyRoutine>();
        if(m_Routine != null) m_Routine.StartRoutine();
    }

    public virtual void Play()
    {
        m_Activate = true;
    }

    public virtual void Stop()
    {
        m_Activate = false;
    }

    // Update is called once per frame
    public override void UpdateCharacter()
    {
        if (m_Routine != null) m_Routine.UpdateRoutine();
        base.UpdateCharacter();
    }

    public override void ReInit()
    {
        transform.position = m_RegisteredPosition;
        if (m_Routine != null) m_Routine.StartRoutine();
        if (!m_PlayImmediate)
        {
            Stop();
        }
        m_Activate = m_PlayImmediate;
    }
}