using UnityEngine;
using System.Collections;

public class Character_Animator : MonoBehaviour
{
	protected Animator m_Animator;
	
	protected virtual void Start()
	{
		m_Animator = GetComponentInChildren<Animator>();
		if(m_Animator == null)
		{
			//Debug.LogWarning("No Animator component is attached");
		}
	}
	
	public virtual void SetSpeed(float speed)
	{
		if(m_Animator) m_Animator.SetFloat("Speed",speed);
	}
	
	public virtual float PlayIdle()
	{
		return 0f;
	}
}