﻿using UnityEditor;
using UnityEngine;
using System.Collections.Generic;

[CustomEditor(typeof(Story))]
public class StoryInspector : Editor
{
    public override void OnInspectorGUI()
    {
        Story myTarget = (Story)target;
        List<StepElementInfo> stepElements = myTarget.StepElements;
        List<ElementInfo> elements = myTarget.Elements;

        // STEP ELEMENTS
        EditorGUILayout.LabelField("Step elements");
        if (stepElements != null && stepElements.Count > 0)
        {
            // Sort the list
            //elements.Sort();

            // Display elements
            int size = stepElements.Count;
            for (int i = 0; i < size; ++i)
            {
                EditorGUILayout.LabelField("Element " + (i + 1));
                GUILayout.BeginHorizontal();
                {
                    string tmpStg;
                    int tmpInt;

                    // Begin
                    GUILayout.Label("Begin");
                    if (stepElements[i].BeginStep == -1) tmpStg = "";
                    else tmpStg = stepElements[i].BeginStep.ToString();
                    tmpStg = GUILayout.TextField(tmpStg, 3);
                    if (tmpStg == "") stepElements[i].BeginStep = -1;
                    else if (int.TryParse(tmpStg, out tmpInt)) stepElements[i].BeginStep = tmpInt;

                    // End
                    if (stepElements[i].EndStep >= 0 && stepElements[i].EndStep <= stepElements[i].BeginStep) stepElements[i].EndStep = stepElements[i].BeginStep + 1;
                    GUILayout.Label("End");
                    if (stepElements[i].EndStep == -1) tmpStg = " ";
                    else tmpStg = stepElements[i].EndStep.ToString();
                    tmpStg = GUILayout.TextField(tmpStg, 3);
                    if (tmpStg == "") stepElements[i].EndStep = -1;
                    else if (int.TryParse(tmpStg, out tmpInt)) stepElements[i].EndStep = tmpInt;

                    // Element
                    GUILayout.Label("Element");
                    stepElements[i].Element = EditorGUILayout.ObjectField(stepElements[i].Element, typeof(Element)) as Element;

                    // One time
                    GUILayout.Label("Critical");
                    stepElements[i].OneTime = EditorGUILayout.Toggle(stepElements[i].OneTime);

                    // Delete button
                    if (GUILayout.Button("Del"))
                    {
                        stepElements.Remove(stepElements[i]);
                        break;
                    }
                }
                GUILayout.EndHorizontal();
            }
        }

        // Button for creating new zone
        if (GUILayout.Button("Add step element"))
        {
            if (stepElements == null)
            {
                stepElements = new List<StepElementInfo>();
            }
            stepElements.Add(new StepElementInfo());
            //Debug.Log("Add new step element");
        }
        EditorGUILayout.Separator();

        // ELEMENTS
        EditorGUILayout.LabelField("Normal elements");
        if (elements != null && elements.Count > 0)
        {
            // Display elements
            int size = elements.Count;
            for (int i = 0; i < size; ++i)
            {
                EditorGUILayout.LabelField("Element " + (i + 1));
                GUILayout.BeginHorizontal();
                {
                    string tmpStg;
                    int tmpInt;

                    // Begin
                    GUILayout.Label("Begin");
                    if (elements[i].BeginStep == -1) tmpStg = "";
                    else tmpStg = elements[i].BeginStep.ToString();
                    tmpStg = GUILayout.TextField(tmpStg, 3);
                    if (tmpStg == "") elements[i].BeginStep = -1;
                    else if (int.TryParse(tmpStg, out tmpInt)) elements[i].BeginStep = tmpInt;

                    // End
                    if (elements[i].EndStep >= 0 && elements[i].EndStep <= elements[i].BeginStep) elements[i].EndStep = elements[i].BeginStep + 1;
                    GUILayout.Label("End");
                    if (elements[i].EndStep == -1) tmpStg = " ";
                    else tmpStg = elements[i].EndStep.ToString();
                    tmpStg = GUILayout.TextField(tmpStg, 3);
                    if (tmpStg == "") elements[i].EndStep = -1;
                    else if (int.TryParse(tmpStg, out tmpInt)) elements[i].EndStep = tmpInt;

                    // Element
                    GUILayout.Label("Element");
                    elements[i].Element = EditorGUILayout.ObjectField(elements[i].Element, typeof(Element)) as Element;
                    if (GUILayout.Button("Del"))
                    {
                        elements.Remove(elements[i]);
                        break;
                    }
                }
                GUILayout.EndHorizontal();
            }
        }

        // Button for creating new zone
        if (GUILayout.Button("Add normal element"))
        {
            if (elements == null)
            {
                elements = new List<ElementInfo>();
            }
            elements.Add(new ElementInfo());
            //Debug.Log("Add new normal element");
        }

        // Apply changement
        if (GUI.changed)
        {
            myTarget.StepElements = stepElements;
            EditorUtility.SetDirty(myTarget);
        }
    }
}