//  Author:
//       Sébastien BELLENOUS <sebastien.bellenous@gmail.com>
//  
// 
//  This program is free software: you can redistribute it and/or modify
//  it at your own risk.

using UnityEngine;
using System.Collections;


public class EnemyInstantiator : MonoBehaviour {
	//public Transform enemy;
	
	public Transform goomba;
	public Transform plant;
	public Transform companion; 
	

	
	public float density = 0.5f;
	// Use this for initialization
	void Start () {
		InstantiateEnemy();
	}
	
	// Update is called once per frame
	void Update () {
		if(GameController.InstantiateEnemies()){
			InstantiateEnemy();
		}
	}
	

	void InstantiateEnemy(){
		
		foreach(Transform children in transform){
    		Destroy(children.gameObject);
		}
		
		int nEnemies = (int)(density*transform.localScale.x);
		Transform enemy;
		if(nEnemies == 1){
			if(!GameController.IsCubeAdded()){
				enemy = companion;
				GameController.CubeAdded();
			}else{
				enemy = plant;
			}
		}else{
			enemy = goomba;	
		}
		for(int i = 0 ; i < nEnemies ; i++){
			Transform clone = Instantiate(enemy, 
				new Vector3(
					transform.position.x+10*i*enemy.localScale.x, 
					transform.position.y+1.6f*transform.localScale.y, 
					transform.position.z
				), enemy.rotation) as Transform;
			clone.parent = transform;
			GameController.NewEnemy();
		}
		GameController.PlatformTreated();
	}
}
