Shader "Unlit/ToonCatt33"
{
    Properties
    {
        [Header(________ Colors ________)]
		_Color("Color", Color) = (1,1,1,1)

		_ShapeAlpha("Shape Alpha", Range( 0.0, 1.0 )) = 1
		[NoScaleOffset] _TexShape("Texture Shape", 2D) = "black" {}

		_BaseRatio("Base Ratio", Range( 0.0, 1.0 )) = 1
		_BaseColor("Base Color", Color) = (1,1,1,1)
		[NoScaleOffset] _ZoneShape("Zone Shape", 2D) = "black" {}

		_FrontColor("Front Color", Color) = (1,1,1,1)
		[NoScaleOffset] _TexFront("Texture Front (fixed)", 2D) = "black" {}

		[NoScaleOffset] _BaseTex("Base Texture (fixed)", 2D) = "white" {}
		
		_DetailColor("Detail Color", Color) = (1,1,1,1)
		[NoScaleOffset] _DetailTex("Detail Texture (fixed)", 2D) = "white" {}

		[Header(________ Normal Map ________)]
		_BumpDepth ("Bump Depth", Range( 0.0, 1.0 )) = 0.0
		[NoScaleOffset] _NormalTex("Normal Texture (fixed)", 2D) = "white" {}

		[Header(________ Shadow ________)]
		_StrenghtLight("Light Strenght", Range( 0.0, 2.0 )) = 1.0
		_StrenghtShadow("Shadow Strenght", Range( -1.0, 1.0 )) = 0.0
		_SmoothShadow("Shadow Smooth", Range( 0.0, 1.0 )) = 0.01

		[Header(________ Specular ________)]
		[HDR] _SpecularColor("Specular Color", Color) = (0.75,0.75,0.75,1)
		_Glossiness("Specular", Float) = 8
		_SmoothSpecular("Specular Smooth", Range( 1.0, 100.0 )) = 0.01

		[Header(________ Rim (Camera) _____)]
		[HDR] _RimColor("Rim Color", Color) = (1,1,1,1)
		_RimAmount("Rim Amount", Range(0, 1)) = 0.716
		_RimThreshold("Rim Threshold", Range(0, 1)) = 0.1	
		_SmoothRim("Rim Smooth", Range( 0.0, 0.2 )) = 0.01
		
		[Header(________ Fresnel ________)]
		[HDR] _FresnelColor("Fresnel Color", Color) = (1,1,1,1)
		_FresnelPower("Fresnel Power", Range(1.0, 10.0)) = 8.0
		_FresnelIntensity("Fresnel Intensity", Range(0, 10)) = 1	

        _MainTex ("Texture", 2D) = "white" {}
    }
    SubShader
    {
        Tags { "RenderType"="Opaque" }
        LOD 100

        Pass
        {
            Tags
			{
				
				"PassFlags" = "OnlyDirectional"
			}

            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag
            // make fog work
            #pragma multi_compile_fog

            #include "UnityCG.cginc"

            struct appdata
            {
                float4 vertex : POSITION;
                float2 uv : TEXCOORD0;
            };

            struct v2f
            {
                float2 uv : TEXCOORD0;
                UNITY_FOG_COORDS(1)
                float4 vertex : SV_POSITION;
            };

            sampler2D _MainTex;
            float4 _MainTex_ST;

            v2f vert (appdata v)
            {
                v2f o;
                o.vertex = UnityObjectToClipPos(v.vertex);
                o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                UNITY_TRANSFER_FOG(o,o.vertex);
                return o;
            }

            fixed4 frag (v2f i) : SV_Target
            {
                // sample the texture
                fixed4 col = tex2D(_MainTex, i.uv);
                // apply fog
                UNITY_APPLY_FOG(i.fogCoord, col);
                return col;
            }
            ENDCG
        }
    }
}
