﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[CreateAssetMenu(menuName = "ScriptableObjects/ScriptableCat")]
public class ScriptableCat : ScriptableObject
{
	public static ScriptableCat Instance
	{
		get
		{
			instance ??= Resources.Load<ScriptableCat>("ScriptableCat");
			return instance;
		}		
	}

	static ScriptableCat instance = null;

	// Shapes
	public Texture2D[] shapeTextureList;
	public Sprite[] shapeIconList;
	public Texture2D[] zoneTextureList;

	public Material catMaterial;
	public Material cat2DMaterial;

	public Sprite CatIcon;

	[Header("FX")]

	public ParticleSystem psHeal;
	public ParticleSystem psHoly;
	public ParticleSystem psShiny;
	public ParticleSystem psCoin;
	public ParticleSystem psHeartExpose;
	public ParticleSystem psHeartEmit;
	public ParticleSystem psSleeping;
	public ParticleSystem psExplode;
	public ParticleSystem psReadyForSex;
	public ParticleSystem psZombieDirt;
	public ParticleSystem psSickEffect;
	public ParticleSystem psShitSmoke;
	public ParticleSystem psVomit;
	public ParticleSystem psBloodGrowing;
	public ParticleSystem psSmoke;
	public ParticleSystem psCarrotSlpatWide;
	public ParticleSystem psWash;
	public ParticleSystem psMagicCharge;
	public ParticleSystem psNukeColored;
	public ParticleSystem psConfettiBlast;
	public ParticleSystem psConfettiBlastBlue;
	public ParticleSystem psSmokeExplosionWhite;
	public ParticleSystem psCartoonyBodySlam;
	public ParticleSystem psMagicMissilesSoftBlue;
	public ParticleSystem psCandyWin;
	public ParticleSystem psCandyLose;
	public ParticleSystem psNovaLightningBlue;
	public ParticleSystem psHitFox;

	public CatModel catPrefab;

	//---------------------------------------------------------------------------------------------
	public Texture2D GetShapeTexture(CAT_SHAPE shape)
	{
		if ((int)shape >= shapeTextureList.Length || shape < 0)
		{
			Debug.LogError("GetTextureShape out of range " + shape);
			return null;
		}

		return shapeTextureList[(int)shape];
	}

	//---------------------------------------------------------------------------------------------
	public Texture2D GetZoneTexture(CAT_ZONE zone)
	{
		if ((int)zone >= zoneTextureList.Length || zone < 0)
		{
			Debug.LogError("GetTextureZone out of range " + zone);
			return null;
		}

		return zoneTextureList[(int)zone];
	}


	//---------------------------------------------------------------------------------------------
	static Sprite customSprite;

	public Sprite GetShapeIcon(CAT_SHAPE shape)
	{
		if ((int)shape >= shapeIconList.Length)
		{
			Debug.LogError("GetTextureShapeFull Invalid " + shape.ToString());
			return null;
		}

		if (shape == CAT_SHAPE.COUNT)
		{
			if (customSprite != null)
			{
				return customSprite;
			}
		}

		return shapeIconList[(int)shape];
	}

	//---------------------------------------------------------------------------------------------
}
