using System.Collections;
using System.Collections.Generic;
using Unity.VisualScripting;
using UnityEngine;
using UnityEngine.Rendering;
using UnityEngine.SceneManagement;

public class PauseMenu : MonoBehaviour
{
    public static bool gameIsPaused = false;
    public GameObject pauseMenuUI;

    public void Resume()
    {
        pauseMenuUI.SetActive(false);
        gameIsPaused = false;
    }

    public void Pause()
    {
        pauseMenuUI.SetActive(true);
        gameIsPaused = true;
    }

    public void MainMenu()
    {
        StateMachine.Instance.changeState(StateMachine.State.MENU);
        gameObject.SetActive(false);
    }

    public void OnPlayQuit()
    {
        Application.Quit();
        Debug.LogError("Jeu Quitt!");
    }
}
