using System.Collections.Generic;
using UnityEngine;

public class PlaySound : MonoBehaviour
{
    [SerializeField] public bool isSpecial;
    [SerializeField] private AudioSource source;
    [SerializeField] protected List<AudioClip> clips;
    [SerializeField] public AudioClip Speciallip;
    [SerializeField] public Color SpecialColor;

    [Header("Pitch Settings")]
    [SerializeField] private float minPitch = 0.9f;
    [SerializeField] private float maxPitch = 1.2f;

    // Fonction  appeler dans OnClick
    public void OnClickPlaySound()
    {
        if (isSpecial)
        {
            // Jouer le son Alien unique
            source.pitch = 1f;
            source.PlayOneShot(Speciallip);
        }
        else
        {
            if (clips == null || clips.Count == 0)
            {
                Debug.LogWarning("Aucun AudioClip dans la liste !");
                return;
            }

            AudioClip randomClip = clips[Random.Range(0, clips.Count)];

            // Pitch alatoire
            source.pitch = Random.Range(minPitch, maxPitch);

            source.PlayOneShot(randomClip);
        }
    }
}