using UnityEngine;

public class ButtonsZoom : MonoBehaviour
{
    [SerializeField] private RectTransform canvasRect; 
    [SerializeField] private float zoomSpeed = 0.2f;
    [SerializeField] private float minScale = 1f;
    [SerializeField] private float maxScale = 1.4f; // 40% zoom limit
    private float newScale;
    void Update()
    {
        //Zoom
        float scroll = Input.GetAxis("Mouse ScrollWheel");

        if (scroll != 0f)
        {
            Vector3 currentScale = canvasRect.localScale;
            newScale = Mathf.Clamp(currentScale.x + scroll * zoomSpeed, minScale, maxScale);
            canvasRect.localScale = new Vector3(newScale, newScale, 1f);

            //Debug.Log("Scroll: " + Input.GetAxis("Mouse ScrollWheel"));

        }
    }
    public float GetCurrentZoom()
    {
        return newScale;
    }
}
