using TMPro;
using UnityEngine;
using UnityEngine.EventSystems;

public class EmailController : MonoBehaviour, IPointerClickHandler
{
    private const string EmailSimon = "simon72610@gmail.com";
    private const string EmailCelia = "lammoglia.celia09340@gmail.com";
    private const string EmailAntonin = "antonin.aubert0@gmail.com";
    
    public void OnPointerClick(PointerEventData eventData)
    {
        var linkIndex = TMP_TextUtilities.FindIntersectingLink(
            GetComponent<TMP_Text>(), 
            eventData.position, 
            null);
        
        var linkId = GetComponent<TMP_Text>().textInfo.linkInfo[linkIndex].GetLinkID();
        
        var email = linkId switch
        {
            "IDSimon" => EmailSimon,
            "IDCelia" => EmailCelia,
            "IDAntonin" => EmailAntonin,
            _ => null
        };
        
        if (email != null)
        {
            Application.OpenURL("mailto:" + email);
        }
    }
    
    
}
