using Global;
using TMPro;
using UnityEngine;

namespace Menu
{
    public class CurrencyCanvas : MonoBehaviour
    {
        public static CurrencyCanvas instance;
        private void OnEnable()
        {
            UpdateCurrencyDisplay();
        }
    
        public void Awake()
        {
            if (instance == null)
            {
                instance = this;
            }
            else
            {
                Destroy(gameObject);
            }
        }
    
        public void UpdateCurrencyDisplay()
        {
            int stars = PlayerStatsManager.instance.GetStars();
            transform.parent.GetChild(0).GetChild(1).GetComponent<TextMeshProUGUI>().text = stars.ToString();
        }
    }
}
