using UnityEngine;
using UnityEngine.UI;

[DefaultExecutionOrder(-10)]
public class UIButtonAudio : MonoBehaviour
{
    public AudioClip clickSound;
    private AudioSource audioSource;

    void Awake()
    {
        audioSource = gameObject.AddComponent<AudioSource>();
    }

    void Start()
    {
        // Trouve tous les boutons présents dans la scène
        Button[] buttons = FindObjectsOfType<Button>(true);

        foreach (var btn in buttons)
        {
            btn.onClick.AddListener(() => PlayClick());
        }
    }

    void PlayClick()
    {
        audioSource.PlayOneShot(clickSound);
    }
}