using UnityEngine;
using UnityEngine.Audio;

namespace Global
{
    public enum Sound
    {
        BUTTON_CLICK,
        ENEMY_DESTROYED,
        ENEMY_HIT,
        END_LEVEL_VICTORY,
        END_LEVEL_DEFEAT
    }

    public class SoundManager : MonoBehaviour
    {
        public static SoundManager Instance;
        private AudioSource _audioSource;
        [SerializeField] private SoundCollection _soundCollection;

        public void Awake()
        {
            if (Instance == null)
            {
                Instance = this;
                DontDestroyOnLoad(gameObject);
            }
            else
            {
                Destroy(gameObject);
            }

            _audioSource = GetComponent<AudioSource>();
        }

        public void PlaySound(Sound sound)
        {
            _audioSource.resource = _soundCollection.GetSoundClip(sound);
            _audioSource.Play();
        }

        public void PlaySoundAsset(AudioResource soundAsset)
        {
            _audioSource.resource = soundAsset;
            _audioSource.Play();
        }
    }
}