using System;
using Global;
using Unity.VisualScripting;
using UnityEngine;

public class TrailSkinManager : MonoBehaviour
{
    private PlayerStatsManager playerStatsManager;
    private void Awake()
    {
        playerStatsManager = PlayerStatsManager.instance;
        if (playerStatsManager == null)
        {
            Debug.LogError("PlayerStatsManager instance is null in TrailSkinManager Awake");
        }
        else
        {
            SkinScheme currentSkin = playerStatsManager.GetCurrentSkin();


            var trailRenderer = GetComponent<TrailRenderer>();
            if (trailRenderer != null && currentSkin != null)
            {
                trailRenderer.widthMultiplier = currentSkin.trailWidth;
                Material customMaterial = currentSkin.customTrailMaterial;
                if (customMaterial != null)
                {
                    trailRenderer.material = customMaterial;
                    // Si le skin utilisé est "Light", activer l’émission de lumière
                    if (currentSkin.skinName == "Light")
                    {
                        trailRenderer.material.EnableKeyword("_EMISSION");
                        trailRenderer.textureScale = new Vector2(1, 0.3f);
                    }
                    else
                    {
                        trailRenderer.material.DisableKeyword("_EMISSION");
                        trailRenderer.textureScale = new Vector2(1, 1);
                    }
                        
                }
                else
                {
                    trailRenderer.startColor = currentSkin.skinStartColor;
                    trailRenderer.endColor = currentSkin.skinEndColor;
                }
            }
        }
    }
}
