using UnityEngine;

[CreateAssetMenu(fileName = "FishSettings", menuName = "ScriptableObjects/FishSettings", order = 1)]
public class FishSettings : ScriptableObject
{
    public float minScaleFactor = 0.8f;
    public float maxScaleFactor = 1f;
    public int minWeight = 50; // In grams
    public int maxWeight = 150; // In grams
    public float swimSpeed = 1;
    public float turnSpeed = 1;
    public float jumpHeight = 2;
    public float jumpProximity = 0.4f;
    public float fxHeight = 0.6f;

    [Space]
    public float timeToFullSize = 3f;
    public float minSwimTime = 3f;
    public float maxSwimTime = 6f;
    public float timeToDisappear = 4f;
    public float changeDirectionCooldown = 5f;
    public float jumpCooldown = 2f;
    public float jumpDuration = 1f; // The jump duration should correspond to the Jump animation duration

    [Space]
    public ParticleSystem jumpFXPrefab;
    public ParticleSystem landFXPrefab;
}
