﻿Shader "Kcm/Degrade"
{
    Properties
    {
        _MainTex("Texture", 2D) = "white" {}
		_Color2("Up Color", Color) = (1.0,1.0,1.0)
		_Color1("Middle Color", Color) = (1.0,1.0,1.0)
		_Color0("Down Color", Color) = (1.0,1.0,1.0)

    }
    SubShader
    {
	// We must be transparent, so other objects are drawn before this one.
        Tags { "RenderType"="Opaque" }

        Pass
        {
            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag

            #include "UnityCG.cginc"

            struct v2f
            {
                float4 vertex : POSITION;
                float2 uv : TEXCOORD0;
            };

            sampler2D _MainTex;
            float4 _MainTex_ST;
			float4 _Color2;
			float4 _Color1;
			float4 _Color0;

            v2f vert(v2f v)
            {
                v2f o;
                o.vertex = UnityObjectToClipPos(v.vertex);
                o.uv = v.uv;
                return o;
            }

            float4 frag(v2f i) : SV_Target
            {
				if (i.uv.y < 0.5)
				{
					float ratio = i.uv.y * 2.0;
					return _Color1 * ratio + _Color0 * (1.0 - ratio);
				}
				else
				{
					float ratio = (i.uv.y - 0.5) * 2.0;
					return _Color2 * ratio + _Color1 * (1.0 - ratio);
				}
            }
            ENDCG
        }
    }

	Fallback "Mobile/VertexLit"
}
/*
{
    Properties {
        _Color ("Main Color", Color) = (1,1,1,1)
        _MainTex ("Base (RGB) Trans (A)", 2D) = "white" {}
    }

    SubShader {
        Tags {"RenderType"="Opaque" "IgnoreProjector"="True" }
        
        ZWrite On
        Lighting Off
        //Fog { Mode Off }

        Pass
		{
            Color [_Color]
            SetTexture [_MainTex] { combine texture * primary } 
        }

		Pass
		{
			//Name "ShadowCaster"
			Tags { "LightMode" = "ShadowCaster" }

			ZWrite On ZTest LEqual Cull Off

			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			#pragma target 2.0
			#pragma multi_compile_shadowcaster
			#include "UnityCG.cginc"

			struct v2f {
				V2F_SHADOW_CASTER;
				UNITY_VERTEX_OUTPUT_STEREO
			};

			v2f vert( appdata_base v )
			{
				v2f o;
				UNITY_SETUP_INSTANCE_ID(v);
				UNITY_INITIALIZE_VERTEX_OUTPUT_STEREO(o);
				TRANSFER_SHADOW_CASTER_NORMALOFFSET(o)
				return o;
			}

			float4 frag( v2f i ) : SV_Target
			{
				SHADOW_CASTER_FRAGMENT(i)
			}
			ENDCG
		}
    }
}
*/