using UnityEngine;
using UnityEngine.InputSystem;

public class S_MouseTrigger : MonoBehaviour
{
    private S_CatGrabBehavior cat;

    void Start()
    {
        cat = GetComponentInParent<S_CatGrabBehavior>();
        if (cat == null)
        {
            Debug.LogError("Chat non trouvé");
            gameObject.SetActive(false);
        }
    }

    void OnTriggerEnter(Collider other)
    {
        if (other.GetComponent<S_Mouse>() != null)
        {
            cat.SetTargetMouse(other.GetComponent<S_Mouse>());
        }
    }

    private void OnTriggerExit(Collider other)
    {
        if (other.GetComponent<S_Mouse>() != null)
        {
            cat.RemoveTargetMouse(other.GetComponent<S_Mouse>());
        }
    }

}
