Shader "Custom/MixerShader"
{
    Properties
    {
        _MainTex ("Texture", 2D) = "white" {}
        _Color ("Main Color", COLOR) = (1,1,1,1)
        _FillColor ("Fill Color", COLOR) = (1,1,1,1)
        _BurnedColor ("Burned Color", COLOR) = (0,0,0,0)
        _FillPercent ("Fill Percent", FLOAT) = (0,0,0,0) 
    }
    SubShader
    {
        Tags { "RenderType"="Opaque" }
        LOD 100

        Pass
        {
            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag
            // make fog work
            #pragma multi_compile_fog

            #include "UnityCG.cginc"

            struct appdata
            {
                float4 vertex : POSITION;
                float2 uv : TEXCOORD0;
            };

            struct v2f
            {
                float2 uv : TEXCOORD0;
                UNITY_FOG_COORDS(1)
                float4 vertex : SV_POSITION;
            };

            sampler2D _MainTex;
            float4 _Color;
            float4 _FillColor;
            float4 _BurnedColor;
            float4 _MainTex_ST;
            float4 _FillPercent;

            v2f vert (appdata v)
            {
                v2f o;
                o.vertex = UnityObjectToClipPos(v.vertex);
                o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                UNITY_TRANSFER_FOG(o,o.vertex);
                return o;
            }

            fixed4 frag (v2f v) : SV_Target
            {                    
                fixed4 col = _Color;
                // sample the texture
                if(v.uv.y < _FillPercent.x) 
                {
                    col = _FillColor;
                }
                if(_FillPercent.x - 1 > 0)
                {
                    col = lerp(col, _BurnedColor, _FillPercent.x - 1);
                }
                // apply fog
                UNITY_APPLY_FOG(v.fogCoord, col);
                return col;
            }
            ENDCG
        }
    }
}
