using System;
using UnityEngine;
using UnityEngine.UI;

public class ScoreManager : MonoBehaviour
{
    public int ExportedScore;
    public Text PreparationScore, CookingScore, ServingScore, Satisfaction, total;

    public DataStorage datas;

    public void OnMenuClicked()
    {
        if (Application.isPlaying)
        {
            GameManager.Instance.SetManager(Manager.MENU);
        }
    }

    void SetScore()
    {
        //PreparationScore.text = "A";
        //CookingScore.text = "B";
        //ServingScore.text = "C";
    }

    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void OnEnable()
    {
        ExportedScore = Algos.SommeTableau(GameManager.Instance.Score);
        PreparationScore.text = datas.IngredientPoints.ToString();
        CookingScore.text = datas.CookingPoints.ToString();
        ServingScore.text = datas.ServingPoints.ToString("F0");
        float satisfactionScore = 0f;
        if (datas.CatSatisfaction.Count > 0)
        {
            for (int i = 0; i < datas.CatSatisfaction.Count; i++)
            {
                satisfactionScore += datas.CatSatisfaction[i];
            }
            satisfactionScore = satisfactionScore / datas.CatSatisfaction.Count;
        }
        Satisfaction.text = (satisfactionScore * 100).ToString("F0") + "%";

        total.text = ((datas.IngredientPoints + datas.CookingPoints + datas.ServingPoints) * satisfactionScore).ToString("F0");
    }

// Update is called once per frame
void Update()
    {
        
    }

    public void OnQuitClicked()
    {
        Debug.Log("Quit");
        if (Application.isPlaying)
        {
            Application.Quit();
        }
    }
}