using System;
using Unity.VisualScripting;
using UnityEngine;
using UnityEngine.Audio;
using UnityEngine.Rendering;
using UnityEngine.UI;
using static System.Net.Mime.MediaTypeNames;

public class Action_B : ActionScript
{
    [SerializeField] MixingParameters mixM, mixI, mixA, mixO, mixU;
    [SerializeField] GameObject canvas;

    [SerializeField] GamesManager gamesManager;

    [Header("Audio")]
    [SerializeField] AudioSource audioSource;
    [SerializeField] AudioClip Alimentadd, RecipePerfect, RecipeMid, RecipeTrash;

    [Header("SFXs")]
    [SerializeField] GameObject textOK;
    [SerializeField] GameObject textPerfect, textTrash;


    void Start()
    {
        ;
    }

    void OnEnable()
    {
        canvas.SetActive(false);
        datas.CookingPoints = 0;
        datas.CookedDoughList.Clear();
        mixSetUp(mixM);
        mixSetUp(mixI);
        mixSetUp(mixA);
        mixSetUp(mixO);
        mixSetUp(mixU);
    }

    public void mixSetUp(MixingParameters mix)
    {
        mix.Doughs.Clear();
        mix.IsFilled = false;
        mix. TimeValue = 0;
        for (int i = 0; i < datas.RawDoughList.Count; i++)
        {
            if (datas.RawDoughList[i].Type == mix.DoughType)
            {
                mix.Doughs.Add(datas.RawDoughList[i]);
            }
        }
        mix.TextNumber.text = mix.Doughs.Count.ToString();
        if (mix.Doughs.Count == 0)
        {
            mix.fillMesh.SetActive(false);
        }
        else
        {
            mix.fillMesh.SetActive(true);
        }
        mix.Mixer.GetComponent<MeshRenderer>().materials[1].SetColor("_FillPercent", new Color(0, 0, 0, 0));

    }

    void Update()
    {
        if (mixM.IsFilled && mixM != null)
        {
            mixM.TimeValue += 1f / mixM.MixDelay * Time.deltaTime;
            mixM.Mixer.GetComponent<MeshRenderer>().materials[1].SetColor("_FillPercent", new Color(mixM.TimeValue, 0, 0,0));
            //mixM.TimeSilder.value = mixM.TimeValue;
        }
        if (mixI.IsFilled && mixI != null)
        {
            mixI.TimeValue += 1f / mixI.MixDelay * Time.deltaTime;
            mixI.Mixer.GetComponent<MeshRenderer>().materials[1].SetColor("_FillPercent", new Color(mixI.TimeValue, 0, 0, 0));
            //.TimeSilder.value = mixI.TimeValue;
        }
        if (mixA.IsFilled && mixA != null)
        {
            mixA.TimeValue += 1f / mixA.MixDelay * Time.deltaTime;
            mixA.Mixer.GetComponent<MeshRenderer>().materials[1].SetColor("_FillPercent", new Color(mixA.TimeValue, 0, 0, 0));

           // mixA.TimeSilder.value = mixA.TimeValue;
        }
        if (mixO.IsFilled && mixO != null)
        {
            mixO.TimeValue += 1f / mixO.MixDelay * Time.deltaTime;
            mixO.Mixer.GetComponent<MeshRenderer>().materials[1].SetColor("_FillPercent", new Color(mixO.TimeValue, 0, 0, 0));

           // mixO.TimeSilder.value = mixO.TimeValue;
        }
        if (mixU.IsFilled && mixU != null)
        {
            mixU.TimeValue += 1f / mixU.MixDelay * Time.deltaTime;
            mixU.Mixer.GetComponent<MeshRenderer>().materials[1].SetColor("_FillPercent", new Color(mixU.TimeValue, 0, 0, 0));

            //mixU.TimeSilder.value = mixU.TimeValue;
        }
    }

    public override void ActionM()
    {
        Action(mixM);
    }
    public override void ActionI()
    {
        Action(mixI);
    }
    public override void ActionA()
    {
        Action(mixA);
    }
    public override void ActionO()
    {

        Action(mixO);
    }
    public override void ActionU()
    {
        Action(mixU);
    }

    public void Action(MixingParameters mix)
    {
        if (mix != null)
        {
            if (mix.IsFilled)
            {

                mix.IsFilled = false;
                if (Mathf.Abs(1 - mix.TimeValue) <= 0.05f / mix.MixDelay)
                {
                    mix.ActiveDough.CookedQuality = 1;
                    datas.CookedDoughList.Add(mix.ActiveDough);
                    audioSource.PlayOneShot(RecipePerfect);
                    GameObject sfx = Instantiate(textPerfect, mix.sfxSpawn.transform);
                    datas.CookingPoints += 100;
                }
                else if (Mathf.Abs(1 - mix.TimeValue) <= 0.1f / mix.MixDelay)
                {
                    mix.ActiveDough.CookedQuality = 0.75f;
                    datas.CookedDoughList.Add(mix.ActiveDough);
                    audioSource.PlayOneShot(RecipePerfect);
                    datas.CookingPoints += 75;
                    GameObject sfx = Instantiate(textPerfect, mix.sfxSpawn.transform);
                }
                else if (Mathf.Abs(1 - mix.TimeValue) <= 0.15f / mix.MixDelay)
                {
                    mix.ActiveDough.CookedQuality = 0.5f;
                    datas.CookedDoughList.Add(mix.ActiveDough);
                    datas.CookingPoints += 50;
                    audioSource.PlayOneShot(RecipeMid);
                    GameObject sfx = Instantiate(textOK, mix.sfxSpawn.transform);

                }
                else if (Mathf.Abs(1 - mix.TimeValue) <= 0.2f / mix.MixDelay)
                {
                    mix.ActiveDough.CookedQuality = 0.25f;
                    datas.CookingPoints += 25;
                    datas.CookedDoughList.Add(mix.ActiveDough);
                    audioSource.PlayOneShot(RecipeMid);
                    GameObject sfx = Instantiate(textOK, mix.sfxSpawn.transform);
                }
                else
                {
                    audioSource.PlayOneShot(RecipeTrash);
                    GameObject sfx = Instantiate(textTrash, mix.sfxSpawn.transform);
                }
                Debug.Log(mix.ActiveDough.CookedQuality);
                mix.TimeValue = 0f;
                mix.Mixer.GetComponent<MeshRenderer>().materials[1].SetColor("_FillPercent", new Color(0, 0, 0, 0));
            }
            else if (mix.Doughs.Count > 0)
            {
                audioSource.PlayOneShot(Alimentadd);
                mix.IsFilled = true;
                mix.ActiveDough = mix.Doughs[0];
                mix.Doughs.RemoveAt(0);
                mix.TextNumber.text = mix.Doughs.Count.ToString();
                if (mix.Doughs.Count == 0)
                {
                    mix.fillMesh.SetActive(false);
                }
            }
        }
        if (mixM.Doughs.Count == 0 && mixI.Doughs.Count == 0 && mixA.Doughs.Count == 0 && mixO.Doughs.Count == 0 && mixU.Doughs.Count == 0
   && mixM.IsFilled == false && mixI.IsFilled == false && mixA.IsFilled == false && mixO.IsFilled == false && mixU.IsFilled == false)
        {
            gamesManager.SkipByNumber();
        }
    }
}
