﻿Shader "Roystan/ToonCat"
{
	Properties
	{
		[Header(________ Colors ________)]
		_Color("Color", Color) = (1,1,1,1)

		_ShapeAlpha("Shape Alpha", Range( 0.0, 1.0 )) = 1
		[NoScaleOffset] _TexShape("Texture Shape", 2D) = "black" {}

		_BaseRatio("Base Ratio", Range( 0.0, 1.0 )) = 1
		_BaseColor("Base Color", Color) = (1,1,1,1)
		[NoScaleOffset] _ZoneShape("Zone Shape", 2D) = "black" {}

		_FrontColor("Front Color", Color) = (1,1,1,1)
		[NoScaleOffset] _TexFront("Texture Front (fixed)", 2D) = "black" {}

		[NoScaleOffset] _BaseTex("Base Texture (fixed)", 2D) = "white" {}
		
		_DetailColor("Detail Color", Color) = (1,1,1,1)
		[NoScaleOffset] _DetailTex("Detail Texture (fixed)", 2D) = "white" {}

		[Header(________ Normal Map ________)]
		_BumpDepth ("Bump Depth", Range( 0.0, 1.0 )) = 0.0
		[NoScaleOffset] _NormalTex("Normal Texture (fixed)", 2D) = "white" {}

		[Header(________ Shadow ________)]
		_StrenghtLight("Light Strenght", Range( 0.0, 2.0 )) = 1.0
		_StrenghtShadow("Shadow Strenght", Range( -1.0, 1.0 )) = 0.0
		_SmoothShadow("Shadow Smooth", Range( 0.0, 1.0 )) = 0.01

		[Header(________ Specular ________)]
		[HDR] _SpecularColor("Specular Color", Color) = (0.75,0.75,0.75,1)
		_Glossiness("Specular", Float) = 8
		_SmoothSpecular("Specular Smooth", Range( 1.0, 100.0 )) = 0.01

		[Header(________ Rim (Camera) _____)]
		[HDR] _RimColor("Rim Color", Color) = (1,1,1,1)
		_RimAmount("Rim Amount", Range(0, 1)) = 0.716
		_RimThreshold("Rim Threshold", Range(0, 1)) = 0.1	
		_SmoothRim("Rim Smooth", Range( 0.0, 0.2 )) = 0.01
		
		[Header(________ Fresnel ________)]
		[HDR] _FresnelColor("Fresnel Color", Color) = (1,1,1,1)
		_FresnelPower("Fresnel Power", Range(1.0, 10.0)) = 8.0
		_FresnelIntensity("Fresnel Intensity", Range(0, 10)) = 1


	}
	SubShader
	{
		Pass
		{
			// Setup our pass to use Forward rendering, and only receive
			// data on the main directional light and ambient light.
			Tags
			{
				"LightMode" = "ForwardBase"
				"PassFlags" = "OnlyDirectional"
			}

			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag

			// Compile multiple versions of this shader depending on lighting settings.
			#pragma multi_compile_fwdbase

			#include "UnityCG.cginc"
			// Files below include macros and functions to assist
			// with lighting and shadows.
			#include "Lighting.cginc"
			#include "AutoLight.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
				float4 uv : TEXCOORD0;
				float3 normal : NORMAL;
				float4 tangent : TANGENT;
			};

			struct v2f
			{
				float4 pos : SV_POSITION;
				float2 uv : TEXCOORD0;
				float2 uv2 : TEXCOORD1;
				float2 uv3 : TEXCOORD3;
				float2 uv4 : TEXCOORD4;
				float3 worldNormal : NORMAL;
				float3 viewDir : TEXCOORD5;

				float3 TtoW0 : TEXCOORD6;
				float3 TtoW1 : TEXCOORD7;
				float3 TtoW2 : TEXCOORD8;

				// Macro found in Autolight.cginc. Declares a vector4
				// into the TEXCOORD2 semantic with varying precision 
				// depending on platform target.
				SHADOW_COORDS(2)
			};

			sampler2D _ZoneShape;
			sampler2D _TexShape;
			sampler2D _TexFront;
			sampler2D _BaseTex;
			sampler2D _DetailTex;

			float4 _Color;
			float _ShapeAlpha;
			float4 _BaseColor;
			float4 _FrontColor;
			float4 _DetailColor;

			sampler2D _NormalTex;
			float _BumpDepth;
			float _SmoothRim;
			float _SmoothShadow;
			float _StrenghtShadow;
			float _StrenghtLight;
			float _SmoothSpecular;
			float _BaseRatio;

			float _Glossiness;
			
			float4 _SpecularColor;
			float4 _RimColor;
			float _RimAmount;
			float _RimThreshold;
			
			float _FresnelPower;
			float _FresnelIntensity;
			float4 _FresnelColor;

			v2f vert(appdata v)
			{
				v2f o;
				o.pos = UnityObjectToClipPos(v.vertex);
				o.worldNormal = UnityObjectToWorldNormal(v.normal);
				o.uv = v.uv;
				o.viewDir = WorldSpaceViewDir(v.vertex);
				
				// Définition de la matrice TBN
				float3 worldNormal = UnityObjectToWorldNormal(v.normal);
				float3 worldTangent = UnityObjectToWorldDir(v.tangent.xyz);
				float3 worldBitangent = cross(worldNormal, worldTangent) * v.tangent.w;

				// Passage des informations de la matrice au fragment shader
				o.TtoW0 = float3(worldTangent.x, worldBitangent.x, worldNormal.x);
				o.TtoW1 = float3(worldTangent.y, worldBitangent.y, worldNormal.y);
				o.TtoW2 = float3(worldTangent.z, worldBitangent.z, worldNormal.z);


				// Defined in Autolight.cginc. Assigns the above shadow coordinate
				// by transforming the vertex from world space to shadow-map space.
				TRANSFER_SHADOW(o)

				return o;
			}

			

			float4 frag(v2f i) : SV_Target
			{
				float3 normal;

				if (_BumpDepth <= 0.0)
				{
					normal = normalize(i.worldNormal);
				}
				else
				{
					// Échantillonnage de la normal map et décodage
					float3 tangentNormal = UnpackNormal(tex2D(_NormalTex, i.uv));
    
					// Modification de la profondeur (BumpDepth)
					tangentNormal.xy *= _BumpDepth;
					tangentNormal = normalize(tangentNormal);

					// Transformation du vecteur normal de l'espace tangent vers l'espace monde
					float3 worldNormal;
					worldNormal.x = dot(i.TtoW0, tangentNormal);
					worldNormal.y = dot(i.TtoW1, tangentNormal);
					worldNormal.z = dot(i.TtoW2, tangentNormal);
    
					// Utilisation du nouveau normal pour les calculs d'éclairage
					normal = normalize(worldNormal);
				}

				// Lighting below is calculated using Blinn-Phong,
				// with values thresholded to creat the "toon" look.
				// https://en.wikipedia.org/wiki/Blinn-Phong_shading_model

				// Calculate illumination from directional light.
				// _WorldSpaceLightPos0 is a vector pointing the OPPOSITE
				// direction of the main directional light.
				float NdotL = dot(_WorldSpaceLightPos0, normal);

				// Samples the shadow map, returning a value in the 0...1 range,
				// where 0 is in the shadow, and 1 is not.
				float shadow = SHADOW_ATTENUATION(i);

				//shadow = 1000.0;

				// Partition the intensity into light and dark, smoothly interpolated
				// between the two to avoid a jagged break.
				float lightIntensity = smoothstep(-_SmoothShadow, _SmoothShadow, NdotL * shadow);
				float4 light = (_StrenghtLight * lightIntensity) * _LightColor0;

				float shadowMask = ((_StrenghtLight * lightIntensity) + 1.0 - _StrenghtShadow);
				
				
				// Multiply by the main directional light's intensity and color.

				float3 viewDir = normalize(i.viewDir);
				float3 halfVector = normalize(_WorldSpaceLightPos0 + viewDir);
				float NdotH = dot(normal, halfVector);

				float specularIntensity = pow(NdotH * lightIntensity, _Glossiness * _Glossiness);
				float specularIntensitySmooth = smoothstep(0.005, 0.01 * _SmoothSpecular, specularIntensity);
				float4 specular = specularIntensitySmooth * _SpecularColor;

				// On calcule la bonne couleur
				float4 final = _Color;

				float4 zoneShape = tex2D(_TexShape, i.uv);
				final *= 1.0f - zoneShape.a * _ShapeAlpha;

				float zoneBack = tex2D(_ZoneShape, i.uv).y;
				final = (1.0 - zoneBack) * final + zoneBack * (1.0 - _BaseRatio + _BaseColor);


				float zoneFront = tex2D(_TexFront, i.uv).x;
				final += final * zoneFront * _FrontColor * 10 * _FrontColor.a;

				//final = (1.0 - zoneFront) * final + zoneFront * _FrontColor;

				final *= tex2D(_BaseTex, i.uv); 
				
				float4 zoneDetail = tex2D(_DetailTex, i.uv) * _DetailColor;
				final = (1.0 - zoneDetail.a) * final + zoneDetail.a * zoneDetail;

				// Calculate rim lighting.
				float rimDot = 1 - dot(viewDir, normal);
				// We only want rim to appear on the lit side of the surface,
				// so multiply it by NdotL, raised to a power to smoothly blend it.
				float rimIntensity = rimDot * pow(NdotL, _RimThreshold);
				rimIntensity = smoothstep(_RimAmount - _SmoothRim, _RimAmount + _SmoothRim, rimIntensity);
				float4 rim = -rimIntensity * _RimColor;				

				// --- Fresnel Lighting ---
				float fresnel = pow(1.0 - saturate(dot(viewDir, normal)), _FresnelPower);
				float4 fresnelLight = _FresnelColor * fresnel * _FresnelIntensity;
				
				return  final * shadowMask  + rim /* + light */ + fresnelLight + specular;

				//return  final * shadowC * (light * rim + fresnelLight + specular);
			}
			ENDCG
		}

		// Shadow casting support.
		UsePass "Legacy Shaders/VertexLit/SHADOWCASTER"
	}

	CustomEditor "CatShaderUI"
}