﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class Perso : MonoBehaviour
{
    //Déplacement perso
    float speed = 0.15f;
    private Rigidbody rbPlayer;

    //Score
    public float Score = 0.0f;
    public Text scoreText;

    //Bonus Fusée
    public Text dureeFusee;
    public GameObject timerFusee;
    float alarmFusee = -1.0f;
    bool Fusee = false;

    //Gestion niveaux
    float MaxLevel01 = 500.0f;
    float MaxLevel02 = 1300.0f;
    public GameObject Player;
    public GameObject ObjectifLvl1;
    public GameObject ObjectifLvl2;
    public GameObject EcranVictoire;
    public GameObject EcranDefaite;

    Vector3 startPosition;

    void Start()
    {
        SuiviCamera.perso = this;
        rbPlayer = GetComponent<Rigidbody>();
        timerFusee.SetActive(false);
        ObjectifLvl1.SetActive(true);
        ObjectifLvl2.SetActive(false);
        EcranVictoire.SetActive(false);
        EcranDefaite.SetActive(false);
        startPosition = transform.position;
    }

    void FixedUpdate()
    {
        //Déplacements 
        if (Input.GetKey(KeyCode.LeftArrow))
        {
            transform.position += transform.TransformDirection(Vector3.left) * speed;
        }

        if (Input.GetKey(KeyCode.RightArrow))
        {
            transform.position += transform.TransformDirection(Vector3.right) * speed;
        }
    }

    void Update()
    {
        //Bonus Fusée
        if (alarmFusee > 0.0f && Fusee == true)
        {
            rbPlayer.velocity += Vector3.up * 3.0f;
            alarmFusee -= Time.deltaTime;
            timerFusee.SetActive(true);
        }

        if (alarmFusee <= 0)
        {
            timerFusee.SetActive(false);
            Fusee = false;
        }

        dureeFusee.text = Mathf.Round(alarmFusee).ToString();


        //Niveaux 
        if (Score >= MaxLevel01)
        {
            ObjectifLvl1.SetActive(false);
            ObjectifLvl2.SetActive(true);
        }

        if (Score >= MaxLevel02)
        {
            EcranVictoire.SetActive(true);
        }

        if (rbPlayer.velocity.y > 0 && transform.position.y > Score)
        {
            Score = transform.position.y;
        }

        scoreText.text = Mathf.Round(Score).ToString();
    }

    public void BonusFusee()
    {
        Fusee = true;
        alarmFusee = 2.0f;
    }

    void OnCollisionEnter(Collision collision)
    {
        if (collision.gameObject.tag == "Mort")
        {
            EcranDefaite.SetActive(true);
            Destroy(this.gameObject);
        }
    }
}
