﻿using UnityEngine;

public enum State //accessible partout
{
    MENU,
    HELP1,
    HELP2,
    HELP3,
    GAME,
    WIN,
    LOSE
}

public class StateMachine : MonoBehaviour
{
    #region Variables
    public State state;

    public GameObject guiMenu;
    public GameObject guiHelp1;
    public GameObject guiHelp2;
    public GameObject guiHelp3;
    public GameObject guiGame;
    public GameObject guiWin;
    public GameObject guiLose;

    static public StateMachine instance; //singleton

    public int nbHealth = 0;
    public int score = 0;
    public float timeInGame = 0;

    public GameObject CatPrefab;
    public GameObject PigeonPrefab;
    public GameObject NutPrefab;

    public GameObject[] SpawnEnnemy;
    public GameObject[] SpawnHeros;

    public int nbrSpawEnnemy = 3;
    public int nbrSpawHeros = 2;

    public GameObject fallingNuts;
    #endregion

    #region Base Functions
    private void Awake()
    {
        if (instance != null) Debug.LogError("Double singleton!");
        instance = this;

        guiMenu.SetActive(false);
        guiGame.SetActive(false);
        guiHelp1.SetActive(false);
        guiHelp2.SetActive(false);
        guiHelp3.SetActive(false);
        guiWin.SetActive(false);
        guiLose.SetActive(false);
    }

    // Use this for initialization
    void Start()
    {
        state = State.MENU;
    }

    // Update is called once per frame
    void Update()
    {
        guiMenu.SetActive(state == State.MENU);
        guiHelp1.SetActive(state == State.HELP1);
        guiHelp2.SetActive(state == State.HELP2);
        guiHelp3.SetActive(state == State.HELP3);
        guiGame.SetActive(state == State.GAME);
        guiWin.SetActive(state == State.WIN);
        guiLose.SetActive(state == State.LOSE);
    }
    #endregion

    #region Functions
    public void SetState(State newState)
    {
        state = newState;
    }
    
    //Fonctions ON CLICK
    public void OnClickQuit()
    {
        Application.Quit();
    }

    public void OnClickPlay()
    {
        nbHealth = 5;
        score = 0;
        timeInGame = 0;

        SetState(State.GAME);
    }

    public void OnClickMenu()
    {
        SetState(State.MENU);
    }

    public void OnCLickHelp(int num)
    {
        switch (num)
        {
            case 1:
                SetState(State.HELP1);
                break;
            case 2:
                SetState(State.HELP2);
                break;
            case 3:
                SetState(State.HELP3);
                break;
        }        
    }
    #endregion
}
