﻿using UnityEngine;
using UnityEngine.UI;

public class StateGame : MonoBehaviour
{
    #region Variables

    public GameObject cameraGame;
    public GameObject cameraMenus;

    StateMachine stateMachine;

    float nextAlarm = -1;
    #endregion

    #region Base Functions
    void Awake()
    {
        stateMachine = StateMachine.instance;
    }

    // Update is called once per frame
    void Update()
    {
        //END OF THE GAME
        stateMachine.timeInGame += Time.fixedDeltaTime;
        if (stateMachine.timeInGame > 150.0f) //2 minutes de jeu
            stateMachine.SetState(State.WIN);
        else if (stateMachine.nbHealth <= 0)
            stateMachine.SetState(State.LOSE);        

        //DEBUG
        ////////////////////////////////////
        /*
         if (Input.GetKeyDown(KeyCode.Space))
            PopPlayer();
        */
        ////////////////////////////////////

        //POP ENNEMY EVERY 5 - 10 SECONDS
        if (nextAlarm > 0.0f && Time.time > nextAlarm)
        {
            PopPlayer();
            nextAlarm = Time.time + UnityEngine.Random.Range(3.0f, 7.0f);
        }
    }
    #endregion

    #region Functions
    //CREATE AN ENNEMY AT A SPAWN 
    void PopPlayer()
    {
        int randomEnnemy = Random.Range(0, 2);
        switch (randomEnnemy)
        {
            case 0:
                Instantiate(stateMachine.CatPrefab, stateMachine.SpawnEnnemy[Random.Range(0, stateMachine.nbrSpawEnnemy)].transform.position + new Vector3(0, 0.5f, 0), Quaternion.Euler(0, 45, 0));
                break;

            case 1:
                Instantiate(stateMachine.PigeonPrefab, stateMachine.SpawnEnnemy[Random.Range(0, stateMachine.nbrSpawEnnemy)].transform.position + new Vector3(0, 3, 0), Quaternion.Euler(0, 45, 0));
                break;
        }
    }

    //LAUNCH ONLY WHEN THE GUI GAME IS ACTIVE
    private void OnEnable()
    {
        //Initialization of the spawn of Ennemies
        nextAlarm = Time.time + UnityEngine.Random.Range(15.0f, 16.0f);
        stateMachine.SpawnEnnemy = GameObject.FindGameObjectsWithTag("Spawn");

        //Initialization of the spawn of heros
        stateMachine.SpawnHeros = GameObject.FindGameObjectsWithTag("SpawnHeros");
        
        cameraGame.SetActive(true);
        cameraMenus.SetActive(false);
        cameraGame.transform.position = stateMachine.SpawnHeros[Random.Range(0, stateMachine.nbrSpawHeros)].transform.position + new Vector3(0, 1.0f, 0);        
    }
    #endregion
}
