﻿using UnityEngine;

public class ShootBullet : MonoBehaviour
{
    #region Variables
    public GameObject ballPrefab;
    public Transform posCanon;
    public AudioSource audioCanon;
    #endregion

    #region Base Fucntions
    // Update is called once per frame
    void Update()
    {
        if (Input.GetMouseButtonDown(0))
        {
            audioCanon.Play();
            //Create a ray from current mouse coordinate
            Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

            //Create ball prefab
            //GameObject ball = Instantiate(ballPrefab, transform.position, transform.rotation);
            GameObject ball = Instantiate(ballPrefab, posCanon.transform.position, transform.rotation);

            //launch the ball
            ball.GetComponent<Rigidbody>().AddForce(ray.direction * 1000.0f);
            Destroy(ball, 2.0f);
        }
    }
    #endregion
}
