﻿using System.Collections;
using System.Collections.Generic;
using System.Text;
using UnityEngine;
using UnityEngine.UI;


public class LevelEnd : UiScreen
{

    public Slider LifePoint;
    public Slider Jetpack;
    public Slider Timer;

    public Text LifeScore;
    public Text JetpackScore;
    public Text TimerScore;

    public Text GlobalScore;


    private GameManager gm;

    private float maxLifePoint;
    private float maxJetpackFuel;
    private float maxTime;

    private float lifePoint;
    private float jetpackFuel;
    private float lastingTime;

    private StringBuilder sb;


    #region Public methods
    public void NextScreen()
    {
        if (GameManager.CurrentState == GameState.LooseScreen)
            gm.ResetCurrentLevel();
        else if (GameManager.CurrentState == GameState.WinScreen)
            gm.NextLevel();
    }
    #endregion


    #region Private methods
    /// <summary>
    /// Calcule le score du joueur pour le niveau.
    /// </summary>
    /// <returns>Le score du niveau</returns>
    private string getScore() => "Score : " + ((int)Mathf.Sqrt(lifePoint * jetpackFuel * lastingTime)).ToString();
    #endregion


    #region Unity methods
    private void Start()
    {
		gm = GameManager.Instance;

        maxLifePoint = gm.GetPlayerMaxLifePoint();
        maxJetpackFuel = gm.GetJetpackMaxFuel();
        maxTime = gm.GetMaxTime();

        sb = new StringBuilder();
    }
    
    private void Update()
    {
        // Update data
        lifePoint = gm.GetPlayerLifePoint();
        jetpackFuel = gm.GetJetpackFuel();
        lastingTime = gm.GetLastingTime();


        // Update images fillAmmount
        LifePoint.value  = lifePoint / maxLifePoint;
        Jetpack.value = jetpackFuel / maxJetpackFuel;
        Timer.value = lastingTime / maxTime;


        // Update end screen of the level
        sb.Append("Santé\n").Append((int)lifePoint).Append(" / ").Append(maxLifePoint);
        LifeScore.text = sb.ToString();
        sb.Clear();

        sb.Append("Jetpack\n").Append((int)jetpackFuel).Append(" / ").Append(maxJetpackFuel);
        JetpackScore.text = sb.ToString();
        sb.Clear();

        sb.Append("Temps\n").Append((int)lastingTime).Append(" / ").Append(maxTime);
        TimerScore.text = sb.ToString();
        sb.Clear();
        
        GlobalScore.text = getScore();
    }
    #endregion

}
