﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ReparationPointGenerator : MonoBehaviour {

	public int TotalPoint = 10;
	public Material ReparationNonOK, ReparationOK;
	GameObject Conteneur;

	// Use this for initialization
	void Start () {
		Init();
	}

    private void OnEnable()
    {
        if (Conteneur) Conteneur.SetActive(true);
    }

    private void OnDisable()
    {
        if (Conteneur) Conteneur.SetActive(false);
    }


	/// <summary>
	/// Change le nombre de point d'interet à creer
	/// </summary>
	/// <param name="nbr">Nombre de point d'interet à creer</param>
	void SetTotalPoint(int nbr) {
		TotalPoint = nbr;
	}

	/// <summary>
	/// Detruit les elements à reparer et recree un niveau;
	/// </summary>
	void RestartNewLevel() {
		Destroy(Conteneur);
		Init();
	}

	/// <summary>
	/// Fabrique le niveau
	/// </summary>
	void Init() {
		Conteneur = new GameObject();
		Conteneur.name = "Conteneur";

		Mesh mesh = transform.GetChild(0).GetComponent<MeshFilter>().mesh;

		for (int i = 0 ; i < TotalPoint ; i++) {
			Vector3 coordpoint = mesh.vertices[Random.Range(0 , mesh.vertexCount - 1)];

			GameObject pointdInteret = GameObject.CreatePrimitive(PrimitiveType.Sphere);
			pointdInteret.transform.SetParent(Conteneur.transform);
			pointdInteret.transform.position = coordpoint;

			ReparationPoint r = pointdInteret.AddComponent<ReparationPoint>();
			r.ReparationNonOK = ReparationNonOK;
			r.ReparationOK = ReparationOK;
		}
	}

}
