﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ReparationPoint : MonoBehaviour {

	public Material ReparationNonOK, ReparationOK;

	public float TimeToRepair = 5;
	public float BlinkSPeed = 6;
	public bool isBlinking = true;
	public bool ShitpIsRepeard = false;


	private float TimeToRepairInittial;
	private Coroutine cr_ReparationENCour, cr_blinkMate;

	// Use this for initialization
	void Start() {

		TimeToRepairInittial = TimeToRepair;
		GetComponent<MeshRenderer>().material = ReparationNonOK;
		Invoke("BlinkMaterial" , 1);

		GetComponent<SphereCollider>().isTrigger = true;

	}

	void BlinkMaterial() {
		//PointMaterial = GetComponent<MeshRenderer>().material;
		cr_blinkMate = StartCoroutine(cr_BlinkMaterial());
	}


	IEnumerator cr_BlinkMaterial() {
		while (isBlinking) {
			float val = Mathf.Sin(Time.time * BlinkSPeed) / 2 + 0.5f;
			//print(val);

			Color c = new Color(0 , 0 , 0 , val);
			GetComponent<MeshRenderer>().material.SetColor("_Color" , c);

			yield return null;
		}
	}

	private void OnTriggerEnter( Collider other ) {
		if (cr_ReparationENCour == null) {
			cr_ReparationENCour = StartCoroutine(StartReparation());
		}
	}

	private void OnTriggerStay( Collider other ) {

	}

	private void OnTriggerExit( Collider other ) {
		StopReparation();
	}

	IEnumerator StartReparation() {
		print("Start Réparation");
		while (TimeToRepair > 0) {

			GetComponent<MeshRenderer>().material.SetColor("_EmissionColor" , Color.Lerp(ReparationOK.GetColor("_EmissionColor") , ReparationNonOK.GetColor("_EmissionColor") , TimeToRepair / TimeToRepairInittial));
			TimeToRepair -= Time.deltaTime;

			yield return null;
		}

		print("Réparation Faite");
		ShitpIsRepeard = true;
		StopReparation();
		shipRepaired();
	}

	void StopReparation() {
		print("Stop Réparation");

		if (cr_ReparationENCour != null) {
			StopCoroutine(cr_ReparationENCour);
			cr_ReparationENCour = null;
		}

		if (!ShitpIsRepeard) {
			GetComponent<MeshRenderer>().material = ReparationNonOK;
			TimeToRepair = TimeToRepairInittial;
		}
	}

	void shipRepaired() {
		StopCoroutine(cr_blinkMate);
		isBlinking = false;

		GetComponent<MeshRenderer>().material = ReparationOK;
		GameManager.Instance.IncrementReparationState();

		GetComponent<SphereCollider>().enabled = false;

	}
}