﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class My_CharacterController_v02 : MonoBehaviour {

	public GameObject Character, SpaceShip;
	public float Distance = 15 ;
	

	public bool ReverseUpDown, ReverseLeftRight;
	public float Speed = 0.1f;
	public ForceMode ForceType;

	[Header("Stat personnage")]
	public float CurrentLife = 100;
	public float MaxLife = 100;
	public float JetPackFuel = 100;
	public float MaxJetPackFuel = 100;

	[Header("Retours d'infos")]
	public Vector3 AngularVelocity;
    public Vector3 Velocity;

	public float OffsetY = 0;
	
	private Rigidbody rb, RbCharacter;
	public ActivateRetroFusees RetroF;
    private readonly float fuelDeficit = 0.002f;

	// Use this for initialization
	void Start() {
		SpaceShip = SpaceShip.transform.GetChild(0).gameObject;

		//Character.transform.localPosition = PositionPersonnage;

		rb = gameObject.GetComponent<Rigidbody>();
		RbCharacter = Character.GetComponent<Rigidbody>();
		//RbCharacter.centerOfMass = Character.transform.position *-1;

	}

	// Update is called once per frame
	void Update() {


		if (GameManager.CurrentState == GameState.Running) {
			//
			// PRESSION CONTINUE ////////////////
			#region Commandes

			if (Input.GetKey(KeyCode.Z) || Input.GetKey(KeyCode.UpArrow)) {
				if (ReverseUpDown) {
					//rb.AddRelativeTorque(Vector3.left * Speed , ForceType);
					RbCharacter.AddRelativeForce(Vector3.down * Speed , ForceType);
					RetroF.ActivateRetroF(retroF.UP , true);
				}
				else {
					//rb.AddRelativeTorque(Vector3.right * Speed , ForceType);
					RbCharacter.AddRelativeForce(Vector3.up * Speed , ForceType);
					RetroF.ActivateRetroF(retroF.DOWN , true);
				}

                JetPackFuel -= fuelDeficit;
			}


			if (Input.GetKey(KeyCode.S) || Input.GetKey(KeyCode.DownArrow)) {
				if (ReverseUpDown) {
					//rb.AddRelativeTorque(Vector3.right * Speed , ForceType);
					RbCharacter.AddRelativeForce(Vector3.up * Speed , ForceType);
					RetroF.ActivateRetroF(retroF.DOWN , true);
				}
				else {
					//rb.AddRelativeTorque(Vector3.left * Speed , ForceType);
					RbCharacter.AddRelativeForce(Vector3.down * Speed , ForceType);
					RetroF.ActivateRetroF(retroF.UP , true);
				}
                JetPackFuel -= fuelDeficit;
            }


			if (Input.GetKey(KeyCode.Q) || Input.GetKey(KeyCode.LeftArrow)) {
				if (ReverseLeftRight) {
					//rb.AddRelativeTorque(Vector3.up * Speed , ForceType);
					RbCharacter.AddRelativeTorque(Vector3.up * Speed , ForceType);
					RetroF.ActivateRetroF(retroF.RIGHT , true);
				}
				else {
					//rb.AddRelativeTorque(Vector3.down * Speed , ForceType);
					RbCharacter.AddRelativeTorque(Vector3.down * Speed , ForceType);
					RetroF.ActivateRetroF(retroF.LEFT , true);
				}
                JetPackFuel -= fuelDeficit;
            }



			if (Input.GetKey(KeyCode.D) || Input.GetKey(KeyCode.RightArrow)) {
				if (ReverseLeftRight) {
					//rb.AddRelativeTorque(Vector3.down * Speed , ForceType);
					RbCharacter.AddRelativeTorque(Vector3.down * Speed , ForceType);
					RetroF.ActivateRetroF(retroF.LEFT , true);
				}
				else {
					//rb.AddRelativeTorque(Vector3.up * Speed , ForceType);
					RbCharacter.AddRelativeTorque(Vector3.up * Speed , ForceType);
					RetroF.ActivateRetroF(retroF.RIGHT , true);
				}
                JetPackFuel -= fuelDeficit;
            }


			if (Input.GetKey(KeyCode.Mouse0)) {
				//rb.AddRelativeTorque(Vector3.down * Speed , ForceType);
				RbCharacter.AddRelativeForce(Vector3.forward * Speed , ForceType);
				RetroF.ActivateRetroF(retroF.FRONT , true);
                //print("Vers l'infini et l'au dela !!");
                JetPackFuel -= fuelDeficit;
            }


			if (Input.GetKey(KeyCode.Mouse1)) {
				//rb.AddRelativeTorque(Vector3.down * Speed , ForceType);
				RbCharacter.AddRelativeForce(Vector3.back * Speed , ForceType);
				RetroF.ActivateRetroF(retroF.BACK , true);
                //print("BACK BACK BACK !!!");
                JetPackFuel -= fuelDeficit;
            }

			if (JetPackFuel <= 0) {
				GameManager.Instance.SetState(GameState.LooseScreen);
			}


			#endregion

			//
			// RELACHEMENT /////////////////////////////////////
			#region Retrofusees
			if (Input.GetKeyUp(KeyCode.Z) || Input.GetKeyUp(KeyCode.UpArrow)) {
				if (ReverseUpDown) {
					RetroF.ActivateRetroF(retroF.UP , false);
				}
				else {
					RetroF.ActivateRetroF(retroF.DOWN , false);
				}
			}

			if (Input.GetKeyUp(KeyCode.S) || Input.GetKeyUp(KeyCode.DownArrow)) {
				if (ReverseUpDown) {
					RetroF.ActivateRetroF(retroF.DOWN , false);
				}
				else {
					RetroF.ActivateRetroF(retroF.UP , false);
				}
			}
			if (Input.GetKeyUp(KeyCode.D) || Input.GetKeyUp(KeyCode.RightArrow)) {
				if (ReverseUpDown) {
					RetroF.ActivateRetroF(retroF.LEFT , false);
				}
				else {
					RetroF.ActivateRetroF(retroF.RIGHT , false);
				}
			}
			if (Input.GetKeyUp(KeyCode.Q) || Input.GetKeyUp(KeyCode.LeftArrow)) {
				if (ReverseUpDown) {
					RetroF.ActivateRetroF(retroF.RIGHT , false);
				}
				else {
					RetroF.ActivateRetroF(retroF.LEFT , false);
				}
			}

			if (Input.GetMouseButtonUp(0)) {
				//rb.AddRelativeTorque(Vector3.down * Speed , ForceType);
				RetroF.ActivateRetroF(retroF.FRONT , false);
				//print("Vers l'infini et l'au dela !!");
			}


			if (Input.GetMouseButtonUp(1)) {
				//rb.AddRelativeTorque(Vector3.down * Speed , ForceType);
				RetroF.ActivateRetroF(retroF.BACK , false);
				//print("BACK BACK BACK !!!");
			}



			#endregion


		}
		gameObject.transform.position = Vector3.zero;
        Velocity = RbCharacter.velocity;


	}

	public void DecreaseLife(float Magnitude) {
		CurrentLife -= Magnitude * 2;

		if (CurrentLife <= 0) {
			GameManager.Instance.SetState(GameState.LooseScreen);
		}
	}



}
