﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class My_CharacterController_v01 : MonoBehaviour {

	public GameObject Camera, Character, Enterprise;
	public Vector3 PositionPersonnage = new Vector3(0 , -0.5f , -0.6f);
	public Vector3 PositionCam = new Vector3(0 , 0.5f , -8);
	public bool RetroHG, RetroHD, RetroBG, RetroBD;

	public bool ReverseUpDown, ReverseLeftRight;
	public float Speed;
	public ForceMode ForceType;

	[Header("Retours d'infos")]
	public Vector3 AngularVelocity;

	public float OffsetY = 0;
	
	private Rigidbody rb;

	// Use this for initialization
	void Start() {
		Enterprise = Enterprise.transform.GetChild(0).gameObject;

		Camera.transform.localPosition = PositionCam;
		Character.transform.localPosition = PositionPersonnage;

		rb = gameObject.GetComponent<Rigidbody>();
	}

	// Update is called once per frame
	void Update() {

		if (Input.GetKey(KeyCode.Z) || Input.GetKey(KeyCode.UpArrow)) {
			if (ReverseUpDown) {
				rb.AddRelativeTorque(Vector3.left * Speed , ForceType);
				print("UP !!");
			}
			else {
				rb.AddRelativeTorque(Vector3.right * Speed , ForceType);
				print("DOWN !!");
			}
		}


		if (Input.GetKey(KeyCode.S) || Input.GetKey(KeyCode.DownArrow)) {
			if (ReverseUpDown) {
				rb.AddRelativeTorque(Vector3.right * Speed , ForceType);
				print("UP !!");
			}
			else {
				rb.AddRelativeTorque(Vector3.left * Speed , ForceType);
				print("DOWN !!");
			}
		}



		if (Input.GetKey(KeyCode.Q) || Input.GetKey(KeyCode.LeftArrow)) {
			if (ReverseLeftRight) {
				rb.AddRelativeTorque(Vector3.down * Speed , ForceType);
				print("LEFT !!");
			}
			else {
				rb.AddRelativeTorque(Vector3.up * Speed , ForceType);
				print("RIGHT !!");
			}
		}

		 
		if (Input.GetKey(KeyCode.D) || Input.GetKey(KeyCode.RightArrow)) {
			if (ReverseLeftRight) {
				rb.AddRelativeTorque(Vector3.up * Speed , ForceType);
				print("LEFT !!");
			}
			else {
				rb.AddRelativeTorque(Vector3.down * Speed , ForceType);
				print("RIGHT !!");
			}
		}

		//Debug.Log(Input.GetAxis("Horizontal") );
		Vector2 NormalisedPositionOnSCreen = new Vector2(Input.mousePosition.x / Screen.width , Input.mousePosition.y / Screen.height);
		float maxSizeY = Enterprise.GetComponent<MeshFilter>().mesh.bounds.extents.y * Enterprise.transform.localScale.y;

		OffsetY = (maxSizeY * NormalisedPositionOnSCreen.x) * 2 - maxSizeY;

		if (OffsetY < maxSizeY * -1) {
			OffsetY = maxSizeY * -1;
		}
		if (OffsetY > maxSizeY ) {
			OffsetY = maxSizeY ;
		}
		



		print(OffsetY);

		#region RETOUR D'INFOS
		{
			AngularVelocity = rb.angularVelocity;

		}
		#endregion


		gameObject.transform.position = new Vector3(0, OffsetY , 0);


	}



}
