﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class ShootController : MonoBehaviour {

    public CameraFollower cameraFollower;

    public GameObject projectile;
    public Transform shotPoint;
    public bool turnToShoot; 
    public Image ProjectileJauge;

    public float offset;
    public float projectilForce;

    private float m_rotationArmZ;
	
	// Update is called once per frame
	void Update ()
    {
        if(turnToShoot == true)
        {
            // Rotation du bras
            Vector3 difference = Camera.main.ScreenToWorldPoint(Input.mousePosition) - transform.position;
            float rotZ = Mathf.Atan2(difference.y, difference.x) * Mathf.Rad2Deg;
            transform.rotation = Quaternion.Euler(0f, 0f, rotZ + offset);
            m_rotationArmZ = transform.localRotation.eulerAngles.z;

            //contrôle du tir 

            //quand on appuie, on réinitialise la force ud projectile
            if (Input.GetMouseButtonDown(0))
                projectilForce = 1.0f;

            //plus on appuie, plus la force augmente 
            if (Input.GetMouseButton(0))
            {
                //projectilForce = Mathf.Clamp(projectilForce + 120f * Time.deltaTime, 1.0f, 100.0f);
                projectilForce = 1.0f + (Mathf.PingPong(1.0f * Time.time, 1.0f) * 99f);
                ProjectileJauge.fillAmount = projectilForce / 99.0f;
            }
               
            //lorsqu'on relâche le bouton, le projectile se crée sur le point désigné.
            else if (Input.GetMouseButtonUp(0))
            {
                GameObject newProjectile =  Instantiate(projectile, shotPoint.position, transform.rotation);
                cameraFollower.GetProjectile(newProjectile);
                newProjectile.GetComponent<Projectile>().SetProjectileProperties(cameraFollower.playerSwitch, projectilForce);
                ProjectileJauge.fillAmount = 0.0f;

                turnToShoot = false;

                cameraFollower.EnableRagdolls();
            }            
        }

        if (turnToShoot == false)
            transform.rotation = Quaternion.Euler(transform.rotation.x, transform.rotation.y, 90f);
    }
}
