﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CameraFollower : MonoBehaviour
{

    public int lvl; //lvl 1,2,3
    public bool playerSwitch = true; //true = player 1; false = player 2

    public ShootController shootControllerPlayer1;
    public ShootController shootControllerPlayer2;

    public GameObject player1Ragdoll;
    public GameObject player2Ragdoll;
    public GameObject player1;
    public GameObject player2;

    public Transform cameraPositionP1;
    public Transform cameraPositionP2;

    public float endOfTurnDuration = 2.0f;

    float axeCameraY;
    float axeCameraX;
    float timer = -1f;
    float timer2 = -1f;
    float timer3 = -1f;

    Vector3 previousPosition;

    private bool m_tooLow = false;
    private bool m_destroyOnceTime = false;
    private bool m_enableWaitForEndOfTurn = false;
    private bool m_projectileEmited = false;
    private bool m_enableCameraMovement = false;


    private GameObject m_projectile;

    public float speed = 100f;

    // Use this for initialization
    void Start()
    {
        shootControllerPlayer1.turnToShoot = true;
        shootControllerPlayer2.turnToShoot = false;
    }

    // Update is called once per frame
    void Update()
    {
        if(StateMachine.instance.state == State.LVL1)
        {
            axeCameraY = transform.position.y;

            if (m_projectile != null)
            {
                m_destroyOnceTime = true;
                m_projectileEmited = true;
                m_enableWaitForEndOfTurn = true;

                transform.position = (m_projectile.transform.position + Vector3.back * 15.0f);

                timer = Time.time + endOfTurnDuration;
                previousPosition = transform.position;
            }

            else if (Time.time > timer && m_projectileEmited)
            {
                if (player1Ragdoll.GetComponent<RagDollHandler>().playerIsDead)
                {
                    Debug.Log("Fin du jeu, victoire joueur 2");
                    StateMachine.instance.activeWinScreen(true);
                }

                else if (player2Ragdoll.GetComponent<RagDollHandler>().playerIsDead)
                {
                    Debug.Log("Fin du jeu, victoire joueur 1");
                    StateMachine.instance.activeWinScreen(false);
                }

                else if (m_enableWaitForEndOfTurn)
                    StartCoroutine("WaitForEndOfTurn");
            }

            if (m_enableCameraMovement)
                MoveCamera();
        }
    }

    public void GetProjectile (GameObject projectile)
    {
        m_projectile = projectile;
    }

    private void MoveCamera ()
    {
        float step = speed * Time.deltaTime;

        m_tooLow = false;
        if (playerSwitch == true && m_destroyOnceTime == true)
        {
            transform.position = Vector3.MoveTowards(transform.position, cameraPositionP2.position, step);
            if (transform.position == cameraPositionP2.position)
            {
                playerSwitch = false;
                m_enableCameraMovement = false;
                m_projectileEmited = false;
                timer = -1f;
            }
        }
        else if (playerSwitch == false && m_destroyOnceTime == true)
        {
            transform.position = Vector3.MoveTowards(transform.position, cameraPositionP1.position, step);
            if (transform.position == cameraPositionP1.position)
            {
                playerSwitch = true;
                m_enableCameraMovement = false;
                m_projectileEmited = false;
                timer = -1f;
            }
        }
    }

    private void SetRagdollsState(bool ragdollState)
    {
        shootControllerPlayer1.turnToShoot = !ragdollState;
        shootControllerPlayer2.turnToShoot = ragdollState;

        player1Ragdoll.SetActive(false);
        player2Ragdoll.SetActive(false);

        player1.SetActive(true);
        player2.SetActive(true);
    }

    public void EnableRagdolls()
    {
        StartCoroutine("EnableRagdollsDelayed");
    }

    public IEnumerator WaitForEndOfTurn()
    {
        m_enableWaitForEndOfTurn = false;
        yield return new WaitForSeconds(endOfTurnDuration);
        Debug.Log("Fin du tour");

        m_enableCameraMovement = true;

        SetRagdollsState(playerSwitch);
    }

    public IEnumerator EnableRagdollsDelayed()
    {
        yield return new WaitForSeconds(2f);

        player1Ragdoll.SetActive(true);
        player2Ragdoll.SetActive(true);

        player1Ragdoll.GetComponent<RagDollHandler>().SetRigidBodies(false);
        player2Ragdoll.GetComponent<RagDollHandler>().SetRigidBodies(false);

        player1.SetActive(false);
        player2.SetActive(false);
    }
}
