using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class MaGUI : MonoBehaviour {
	
	public string state = "menu";
	public float timerFinish;
	public int level;
	
	
	float timer;
	
	//GUI
	public Texture2D imgMenu;
	public Texture2D imgMenuSans;
	public Texture2D sansImage;
	public Texture2D perdu;
	public Texture2D cestGagne;
	
	public GUIStyle btnJouer;
	public GUIStyle btnScore;
	public GUIStyle btnQuitter;
	public GUIStyle btnContinuer;
	public GUIStyle btnRecommencer;
	public GUIStyle btnMenu;
	public GUIStyle melanger;
	public GUIStyle ecriture;
	public GUIStyle ecritureTitre;
	public GUIStyle ecritureSousTitre;
	
	public GUIStyle flecheDroite;
	public GUIStyle flecheGauche;
	public GUIStyle flecheHaut;
	public GUIStyle flecheBas;
	

	//les 5 différents types de virus
	public GameObject[] virus=new GameObject[5];
	public Texture2D[] virusMort=new Texture2D[10];
	public GameObject[] organes=new GameObject[3];
	caseVirus[,,] indexCases=new caseVirus[6,6,6]; // FACE, width, height
	List<caseVirus> virusSelectionned=new List<caseVirus>() ;
	
	//les scores
	string[] meilleursJoueurs1 = new string[5];// Level, Classement
	string[] meilleursJoueurs2 = new string[5];
	string[] meilleursJoueurs3 = new string[5];
	
	float[] meilleursTemps1 = new float[5];
	float[] meilleursTemps2 = new float[5];
	float[] meilleursTemps3 = new float[5];
	
	//le joueur actuel
	string name="";
	
	//des belles paillettes
	public GameObject particules;
	
	//compteurs sur un niveau
	int compteur1;
	int compteur2;
	int compteur3;
	int compteur4;
	int compteur5;
	int compteur6;
	
	//resolution ecran
	private float native_width=1024;
	private float native_height=768;
	
	//face à finir
	bool[] faceVerrouillee=new bool[6] {false,false,false,false,false,false};
	
	//booléen quand on est dans la mouise
	bool cestLaMerde=false;
	bool reLaMerde=false;
	bool dansLeTop5=false;
	bool afficherFaceVerouillee=false;
	
	void Start () {
		
		//création tableau de virus
		for (int i=0;i<6;i++)
		for (int j=0;j<6;j++)
		for (int k=0;k<6;k++)
		{
			indexCases[i,j,k] = new caseVirus();
		}
		level=0;
		
		//récupérer les top5 de chaque niveau
		for(int i=0;i<meilleursJoueurs1.Length;i++)
		{
			meilleursJoueurs1[i] = PlayerPrefs.GetString("Nom1"+i);
			meilleursTemps1[i] = PlayerPrefs.GetFloat("top1"+i);
			
			if(meilleursJoueurs1[i]==string.Empty)
				meilleursJoueurs1[i]="personne";
			if(meilleursTemps1[i]==60)
				meilleursTemps1[i]=0;
			
		}
		
		for(int i=0;i<meilleursJoueurs2.Length;i++)
		{
			meilleursJoueurs2[i] = PlayerPrefs.GetString("Nom2"+i);
			meilleursTemps2[i] = PlayerPrefs.GetFloat("top2"+i);
			
			if(meilleursJoueurs2[i]==string.Empty)
				meilleursJoueurs2[i]="personne";
			if(meilleursTemps2[i]==60)
				meilleursTemps2[i]=0;
			
			
		}
		
		for(int i=0;i<meilleursJoueurs3.Length;i++)
		{
			meilleursJoueurs3[i] = PlayerPrefs.GetString("Nom3"+i);
			meilleursTemps3[i] = PlayerPrefs.GetFloat("top3"+i);
			
			if(meilleursJoueurs3[i]==string.Empty)
				meilleursJoueurs3[i]="personne";
			if(meilleursTemps3[i]==60)
				meilleursTemps3[i]=0;
		
		
		}
		////
	
	}
	
	void Update () {
		switch (state){
			case "init": UpdateInit(); break;
			case "jeu": UpdateJeu(); break;
			case "win": UpdateWin(); break;
		}
	}
	
	void OnGUI () {
		
		//s'adapter à chaque écran
		float rx=Screen.width/native_width;
		float ry=Screen.height/native_height;
		
		GUI.matrix = Matrix4x4.TRS (new Vector3(0, 0, 0), Quaternion.identity, new Vector3 (rx, ry, 1));
		//
		
		switch (state){
			case "init1": OnGUIInit1();break;
			case "jeu": OnGUIJeu(); break;
			case "menu": OnGUIMenu(); break;
			case "score": OnGUIScore(); break;
			case "loose": OnGUILoose(); break;
			case "win": OnGUIWin();break;
		}
		
	}
	
	void OnGUIMenu () {
		
		//mon menu
		level=0;
		
		GUI.DrawTexture(new Rect(0, 0, 1024, 768), imgMenu);
		
		if (GUI.Button(new Rect(200, 450, 180, 200), "", btnJouer)){
			state = "init1";
		}
		if (GUI.Button(new Rect(400, 450, 170, 200), "", btnScore)){
			state = "score";
		}
		if (GUI.Button(new Rect(600, 450, 210, 200), "", btnQuitter)){
			Application.Quit();
		}
	}
	
	void OnGUIInit1()
	{
		//pour entrer le nom du joueur
		GUI.DrawTexture(new Rect(0, 0, 1024, 768), imgMenuSans);
		
		GUI.Label(new Rect(440,460,200,50),"Entrer votre nom :",ecriture);
			
		name = GUI.TextField(new Rect(Screen.width/2-130,500,200,30),name);
			
		if(GUI.Button(new Rect(Screen.width/2+80,500,30,30),"ok"))
		{
				state = "init";
		}
		
	}
	
	void UpdateInit(){
		//init valeurs ...
		
		//active le renderer du cube à moitié transparent
		GameObject.FindGameObjectWithTag("aCacher").renderer.enabled=true;
		
		//repositionner correctement la caméra
		Camera.mainCamera.transform.position = new Vector3(5,5,-25);
		
		Quaternion rotateCamera = Quaternion.identity;
		rotateCamera.eulerAngles = new Vector3(0,0,0);
		Camera.mainCamera.transform.rotation = rotateCamera;
		
		//désactivation particules
		particules.renderer.enabled=false;
		
		//toute les faces sont de nouveau contaminées
		for(int i=0;i<faceVerrouillee.Length;i++)
			faceVerrouillee[i]=false;
		
		//destruction des anciens gameObject
		foreach(caseVirus c in indexCases)
		{
			Destroy(c.virus);
		}
		
		GenererLevel(level);
		
		
		compteur1=0;
		compteur2=0;
		compteur3=0;
		compteur4=0;
		compteur5=0;
		compteur6=0;
		
		//initialisation booléens
		reLaMerde=false;
		cestLaMerde=false;
		
		//réglage du timer (mouhahaha)
		if(level==2)
			timer=80.0f;
		else timer = 60.0f;
		timerFinish=timer;
		
		//on passe à la suite
		state="jeu";
		
	}
	
	void OnGUIJeu () {
		//GUI timer
		GUI.Label(new Rect(100, 600, 300, 50), "" + (int)(timer) + " s",ecritureTitre);
		
		//déplacement autour du cube (avec une méthode ultra bidon qui marche pas du tonnerre)
		if(GUI.Button(new Rect(844,344,80,80),"",flecheDroite))
			transform.RotateAround(new Vector3(4.5f,4.5f,4.5f),-Vector3.up,30.0f);
		if(GUI.Button(new Rect(80,344,80,80),"",flecheGauche))
			transform.RotateAround(new Vector3(4.5f,4.5f,4.5f),Vector3.up,30.0f);
		if(GUI.Button(new Rect(472,40,80,80),"",flecheHaut))
			transform.RotateAround(new Vector3(4.5f,4.5f,4.5f),Vector3.right,30.0f);
		if(GUI.Button(new Rect(472,628,80,80),"",flecheBas))
			transform.RotateAround(new Vector3(4.5f,4.5f,4.5f),-Vector3.right,30.0f);
		
		
		//but à atteindre
		GUI.Label(new Rect(new Rect(880,5,100,20)),"face 1 : "+compteur1+" / 30",ecriture);
		GUI.Label(new Rect(new Rect(880,30,100,20)),"face 2 : "+compteur2+" / 30",ecriture);
		GUI.Label(new Rect(new Rect(880,55,100,20)),"face 3 : "+compteur3+" / 30",ecriture);
		GUI.Label(new Rect(new Rect(880,80,100,20)),"face 4 : "+compteur4+" / 30",ecriture);
		GUI.Label(new Rect(new Rect(880,105,100,20)),"face 5 : "+compteur5+" / 30",ecriture);
		GUI.Label(new Rect(new Rect(880,130,100,20)),"face 6 : "+compteur6+" / 30",ecriture);
		
		//s'il n'y a plus de possibilité, on remélange les virus
		if(GUI.Button(new Rect(50,50,150,100),"",melanger))
			Remelanger();
		
		//indication quand une face a été décontaminée
		if(afficherFaceVerouillee)
			GUI.Label(new Rect(412,730,100,20),"Bravo, vous venez de décontaminer une face!",ecriture);
		
	}
	
	void UpdateJeu(){
		
		//timer
		if (timer>0){
			timer-=Time.deltaTime;
		}
		
		//vérification pour savoir si on perd ou pas
		GagnerOuPerdu();
		
		//sur quel virus je clic
		Ray ray=Camera.main.ScreenPointToRay(Input.mousePosition);
		RaycastHit hit;
		
		if(Input.GetMouseButtonDown(0))
		{
				if(Physics.Raycast(ray,out hit,1000.0f))
				{
					ClearIndexes();
						
						for (int i=0;i<6;i++)
						for (int j=0;j<6;j++)
						for (int k=0;k<6;k++)
						{
							if(hit.collider.gameObject==indexCases[i,j,k].virus)
							{
								//vérification si il y a d'autres virus du même type autour
								Verification(indexCases[i,j,k], null);
							
								//on change  les types de virus de ceux sélectionnés
								ChangerLesCases(virusSelectionned);
								break;
							}
						}
				}
		}
	}
	
	
	void OnGUILoose(){
		
		GUI.DrawTexture(new Rect(0,0,1024,768),perdu);
		
		if (GUI.Button(new Rect(230, 550, 267, 150), "", btnRecommencer)){
			state = "init";  
		}
		if (GUI.Button(new Rect(630, 550, 82, 150), "", btnMenu)){
			state = "menu";
		}
	}
	
	void UpdateWin()
	{
		//désactivation renderer du cube à moitié transparent
		GameObject.FindGameObjectWithTag("aCacher").renderer.enabled=false;
		
		//remettre la caméra au point de départ
		Camera.mainCamera.transform.position = new Vector3(5,5,-25);
		
		Quaternion rotateCamera = Quaternion.identity;
		rotateCamera.eulerAngles = new Vector3(0,0,0);
		Camera.mainCamera.transform.rotation = rotateCamera;
		
		
		//le score du joueur
		timerFinish=timer;
		
		//bon ou mauvais score
		if(!reLaMerde)
		{
			NouveauScore(timerFinish);
		}
		
		//destruction des GameObject virus car l'organe est guéri
		foreach(caseVirus c in indexCases)
		{
			Destroy(c.virus);
		}
		
		//des belles particules parce que "youhou, l'organe est guéri"
		particules.renderer.enabled=true;
		
		//petite animation de l'organe tout content
		if(level==0)
			organes[level].transform.Rotate(30*Time.deltaTime,0,0);
		
		else if(level==1)
		{
			organes[level].transform.Translate(new Vector3(0,Mathf.Sin(Time.time*10)*0.01f,0));
			organes[level].transform.Rotate(0,30*Time.deltaTime,0);
		}
		
		else if(level==2)
			organes[level].transform.localScale=new Vector3(Mathf.Sin(Time.time)+1,Mathf.Sin(Time.time)+1,Mathf.Sin(Time.time)+1);
	
		//pour que ça dure un peu de temps (avec booléen pour être sûr qu'on ne passe qu'une fois dedans)
		if(!cestLaMerde)
		{
			StartCoroutine(patienter());
		}
			//
		
	}
	
	void OnGUIWin()
	{
		GUI.DrawTexture(new Rect(412,50, 200, 200),cestGagne);
	}
	
	
	void OnGUIScore(){
		
		GUI.DrawTexture(new Rect(0, 0, 1024, 768),sansImage);
		
		//Affichage du top5 du niveau avec certaines différences selon le level
		if(level>0)
			GUI.Label(new Rect(362, 100, 300, 50), "Score Niveau "+level+" : ",ecritureTitre);
		int hauteur = 200;
		
		if(level==0)//génération du cube entier au début du jeu
		{
			GUI.Label(new Rect(80, 100, 300, 50), "Score Niveau 1 : ",ecritureSousTitre);
			for(int i=0;i<5;i++)
			{
				GUI.Label(new Rect(100, hauteur, 300, 50), ""+meilleursJoueurs1[i],ecriture);
				GUI.Label(new Rect(200, hauteur, 300, 50), ""+meilleursTemps1[i],ecriture);
				hauteur+=50;
			}
			
			hauteur = 200;
			GUI.Label(new Rect(380, 100, 300, 50), "Score Niveau 2 : ",ecritureSousTitre);
			for(int i=0;i<5;i++)
			{
				GUI.Label(new Rect(400, hauteur, 300, 50), ""+meilleursJoueurs2[i],ecriture);
				GUI.Label(new Rect(500, hauteur, 300, 50), ""+meilleursTemps2[i],ecriture);
				hauteur+=50;
			}
			
			hauteur = 200;
			GUI.Label(new Rect(680, 100, 300, 50), "Score Niveau 3 : ",ecritureSousTitre);
			for(int i=0;i<5;i++)
			{
				GUI.Label(new Rect(700, hauteur, 300, 50), ""+meilleursJoueurs3[i],ecriture);
				GUI.Label(new Rect(800, hauteur, 300, 50), ""+meilleursTemps3[i],ecriture);
				hauteur+=50;
			}
		}
		
		if(level==1)
		{
			for(int i=0;i<5;i++)
			{
				GUI.Label(new Rect(400, hauteur, 300, 50), ""+meilleursJoueurs1[i],ecriture);
				GUI.Label(new Rect(500, hauteur, 300, 50), ""+meilleursTemps1[i],ecriture);
				hauteur+=50;
			}
		}
		else if(level==2)
		{
			for(int i=0;i<5;i++)
			{
				GUI.Label(new Rect(400, hauteur, 300, 50), ""+meilleursJoueurs2[i],ecriture);
				GUI.Label(new Rect(500, hauteur, 300, 50), ""+meilleursTemps2[i],ecriture);
				hauteur+=50;
			}
		}
		else if(level==3)
		{
			for(int i=0;i<5;i++)
			{
				GUI.Label(new Rect(400, hauteur, 300, 50), ""+meilleursJoueurs3[i],ecriture);
				GUI.Label(new Rect(500, hauteur, 300, 50), ""+meilleursTemps3[i],ecriture);
				hauteur+=50;
			}
		}
		
		////
		
		if(level<3 && level>0)
		{
			if (GUI.Button(new Rect(200, 450, 290, 200), "", btnContinuer))
				state = "init"; // charger le niveau suivant
		}
		
		int largeur = 600;
		if(level==0 || level==3)
			largeur=400;
		if (GUI.Button(new Rect(largeur, 450, 130, 200), "", btnMenu)){
			{
				state = "menu";
				if(level==3)
					level=0;
			}
			
		}
	}
	
	void ClearIndexes()
	{
		//toutes les vérifs des virus sont remises à zéro
		for (int i=0;i<6;i++)
		for (int j=0;j<6;j++)
		for (int k=0;k<6;k++)
		{
			indexCases[i,j,k].verifier=false;
		}
		
		//nettoyer la liste qui récupère les méchants virus pas beau à éliminer
		virusSelectionned.Clear();
	}
	
	void GenererLevel(int level)
	{
		//activer le renderer que de l'organe à montrer selon le niveau
		for(int i=0;i<organes.Length;i++)
		{
			Component[] yo = organes[i].GetComponentsInChildren(typeof(Renderer));
			foreach(Renderer r in yo)
			{
				if(i==level)
				{
					r.enabled=true;
				}
				else
				{
					r.enabled=false;
				}
			}
		}
		
		if(level==0)
		{
			//face 1 et 2
			int face=0;
			for(int i=0;i<6;i++)
			{
				for(int j=0;j<6;j++)
				{
					Quaternion rotation=Quaternion.identity;
					rotation.eulerAngles=new Vector3(-90,180,0);
					InstantierVirus(new Vector3(i*2,j*2,-2),rotation,face, i, j,level);	
				}
			}
			
			face=1;
			for(int i=0;i<6;i++)
			{
				for(int j=0;j<6;j++)
				{
					Quaternion rotation=Quaternion.identity;
					rotation.eulerAngles=new Vector3(-90,0,0);
					InstantierVirus(new Vector3(i*2,j*2,12),rotation,face, i, j,level);
				}
			}
		
			
			//face 3 et 4
			
			face=2;
			for(int i=0;i<6;i++)
			{
				for(int j=0;j<6;j++)
				{
					Quaternion rotation=Quaternion.identity;
					rotation.eulerAngles=new Vector3(0,180,0);
					InstantierVirus(new Vector3(i*2,-2,j*2),rotation,face, i, j,level);
				}
			}
			
			face=3;
			for(int i=0;i<6;i++)
			{
				for(int j=0;j<6;j++)
				{	
					Quaternion rotation=Quaternion.identity;
					rotation.eulerAngles=new Vector3(180,180,0);
					InstantierVirus(new Vector3(i*2,12,j*2),rotation,face, i, j,level);
				}
			}
			
			//face 4 et 2
			
			face=4;
			for(int i=0;i<6;i++)
			{
				for(int j=0;j<6;j++)
				{
					Quaternion rotation=Quaternion.identity;
					rotation.eulerAngles=new Vector3(-90,0,-90);
					InstantierVirus(new Vector3(-2,i*2,j*2),rotation,face, i, j,level);
				}
			}
			
			face=5;
			for(int i=0;i<6;i++)
			{
				for(int j=0;j<6;j++)
				{
					Quaternion rotation=Quaternion.identity;
					rotation.eulerAngles=new Vector3(-90,0,90);
					InstantierVirus(new Vector3(12,i*2,j*2),rotation,face, i, j,level);
				}
			}
		}
		else //remplacement des méchants durant une partie
		{
			foreach(caseVirus c in indexCases)
			{
				Quaternion rotation=RotationPourInstantier(c.face);
				InstantierVirus(c.position,rotation,c.face,c.posA,c.posB,level);
			}
		}
	}
	
	
	int ChoixVirus(int level)//quel type de virus sera le méchant instantié
	{
		int objet=Random.Range(0,3+level);
		return objet;
	}
	
	
	void InstantierVirus(Vector3 positionVirus,Quaternion r,int face, int a, int b,int level)
	{
		int objet=ChoixVirus(level);
		GameObject type= virus[objet];
		GameObject mechant = (GameObject) Instantiate(type,positionVirus,r);
		//mechant.name="mechant"+numcase;
		
		EnregistrementCases(objet,face,mechant,a,b,positionVirus);
	}
	
	
	void EnregistrementCases(int type,int face,GameObject obj, int a, int b, Vector3 pos)
	{
		//on enregistre tout le contenu de chaque case pour s'y retrouver quand on fait des modifs
		indexCases[face,a,b].forme=type;
		indexCases[face,a,b].face=face;
		indexCases[face,a,b].virus=obj;
		indexCases[face,a,b].posA=a;
		indexCases[face,a,b].posB=b;
		indexCases[face,a,b].position=pos;
		indexCases[face,a,b].verifier=false;
	}
	
	
	void Verification(caseVirus caseClic, caseVirus initialCase)// quelles sont les cases concernées par l'éliminition
	{
		if (caseClic.virus == null) return;
		/*if (myCase.verifier) return;
		myCase.verifier = true;*/
		if (caseClic.verifier) return;
		caseClic.verifier = true;
		
		if (initialCase == null)
		{
			initialCase = caseClic;
		}
		
		if (initialCase.face!=caseClic.face) return;
		if (initialCase.forme !=caseClic.forme) return;
		
		virusSelectionned.Add(caseClic);

		if (caseClic.posA-1 >= 0)
		{		
			Verification(indexCases[caseClic.face,caseClic.posA-1,caseClic.posB], initialCase);
		}
		
		if (caseClic.posA+1 < 6)
		{		
			Verification(indexCases[caseClic.face,caseClic.posA+1,caseClic.posB], initialCase);
		}
		
		if (caseClic.posB-1 >= 0)
		{		
			Verification(indexCases[caseClic.face,caseClic.posA,caseClic.posB-1], initialCase);
		}
		
		if (caseClic.posB+1 < 6)
		{		
			Verification(indexCases[caseClic.face,caseClic.posA,caseClic.posB+1], initialCase);
		}
	
	}
	
	
	void ChangerLesCases(List<caseVirus> aModifier)
	{ //une fonction dans une fonction dans une fonction....
		if(aModifier.Count>2)
		{
			StartCoroutine(AllumerVirusSelectionnes(aModifier));
			
			
		}
	}
	
	Quaternion RotationPourInstantier(int face)
	{
		//pour que les virus s'instantient dans le bon sens selon la face ou ils apparaissent
		
		Vector3 direction=Vector3.zero;
		
		switch(face)
		{
			case 0: direction=new Vector3(-90,180,0); break;
			case 1: direction=new Vector3(-90,0,0); break;
			case 2: direction=new Vector3(0,180,0); break;
			case 3: direction=new Vector3(180,180,0); break;
			case 4: direction=new Vector3(-90,0,-90); break;
			case 5: direction=new Vector3(-90,0,90); break;
		}
		
		Quaternion rotation=Quaternion.identity;
		rotation.eulerAngles=direction;
		return rotation;
	}
	
	void FaceFinie(int face)
	{
		//mode "capoute" : changement des textures des virus de la face concernée
		if(!faceVerrouillee[face])
		{
			StartCoroutine(Blabla());	
		}
		
		faceVerrouillee[face]=true;
		
		for(int i=0;i<6;i++)
		for(int j=0;j<6;j++)
		{
			Renderer yo =(Renderer) indexCases[face,i,j].virus.GetComponentInChildren(typeof(Renderer));
			Material[] m=yo.materials;
			
			int a=indexCases[face,i,j].forme*2;
			int b=a+1;
			
			m[0].mainTexture=virusMort[b];
			m[1].mainTexture=virusMort[a];
		}
	}
	
	void GagnerOuPerdu()
	{
		if(compteur1==30 && compteur2==30 && compteur3==30 && compteur4==30 && compteur5==30 && compteur6==30 && timer>=0)
		{
			cestLaMerde=false;
			state = "win";
		}
			
		if(timer<=0 && (compteur1<30 || compteur2<30 || compteur3<30 || compteur4<30 || compteur5<30 || compteur6<30))
		{
			state="loose";
		}
	}
	
	void Remelanger()
	{
		//Debug.Log("tableau : "+faceVerrouillee[0]+faceVerrouillee[1]+faceVerrouillee[2]+faceVerrouillee[3]);
		for (int i=0;i<6;i++)
		for (int j=0;j<6;j++)
		for (int k=0;k<6;k++)
		{
			if(!faceVerrouillee[i])
			{
				caseVirus yo=indexCases[i,j,k];
				Destroy(yo.virus);
				Quaternion rotation=RotationPourInstantier(i);
				InstantierVirus(yo.position,rotation,yo.face,yo.posA,yo.posB,level);
			}
		}
	}
	
	void TraitementDesVirus(List<caseVirus> aModifier)
	{
		//on regarde si la face est décontaminée, si non, on modifie les méchants virus sélectionnés
		//si oui,on change la couleur de la face décontaminée en mode "tous les virus sont capoutes"
		
		foreach(caseVirus cv in aModifier)
			{
				int compteurDeLaFace=0;
				
				switch(cv.face)
				{
					case 0:	compteurDeLaFace=compteur1; break;
					case 1: compteurDeLaFace=compteur2; break;
					case 2:	compteurDeLaFace=compteur3; break;
					case 3: compteurDeLaFace=compteur4; break;
					case 4: compteurDeLaFace=compteur5; break;
					case 5: compteurDeLaFace=compteur6; break;
				}
				
				if(compteurDeLaFace<30)
				{	
					switch(cv.face)
					{
						case 0:	compteur1++;
								compteurDeLaFace=compteur1; break;
						case 1: compteur2++;
								compteurDeLaFace=compteur2; break;
						case 2:	compteur3++;
								compteurDeLaFace=compteur3; break;
						case 3: compteur4++;
								compteurDeLaFace=compteur4; break;
						case 4: compteur5++;
								compteurDeLaFace=compteur5; break;
						case 5: compteur6++;
								compteurDeLaFace=compteur6; break;
					}

					Destroy(cv.virus);
					
					Quaternion rotation=RotationPourInstantier(cv.face);

					
					InstantierVirus(cv.position,rotation,cv.face,cv.posA,cv.posB,level);
				}
				else
				{
					FaceFinie(cv.face);
				}
			}
	}
	
	void FaceSelectionnee(List<caseVirus> mesVirus)
	{
		//rapide changement des textures pour détecter quels virus ont été séléctionnés
			foreach(caseVirus c in mesVirus)
			{
				Renderer yo =(Renderer) c.virus.GetComponentInChildren(typeof(Renderer));
				Material[] m=yo.materials;
			
				m[0].mainTexture=virusMort[1];
				m[1].mainTexture=virusMort[1];
			}
		
	}
	
	IEnumerator Blabla()
	{
		//on active le blabla pour dire "bravo, une face est décontaminée, youhouhou"
		afficherFaceVerouillee=true;
		yield return new WaitForSeconds(4.0f);
		afficherFaceVerouillee=false;
	}
		
	
	
	IEnumerator patienter()
	{
		//on laisse un peu de temps pour que l'animation du "youpla, tu as gagné" se joue
		//après, on passe à l'affichage des scores
		cestLaMerde=true;
		yield return new WaitForSeconds(5.0f);
		level++;
		state="score";
	}
	
	IEnumerator AllumerVirusSelectionnes(List<caseVirus> mesVirus)
	{
		//on change la couleur des virus selectionnés
		FaceSelectionnee(mesVirus);
		yield return new WaitForSeconds(0.1f);
		
		TraitementDesVirus(mesVirus);
	}
	
	void NouveauScore(float temps)
	{
		// enregistrement du score si le joueur entre dans le Top5
		//tri des scores du meilleur au plus "bouh"
		string[] tableauNoms=new string[5];
		float[] tableauScores=new float[5];
		
		if(level==0)
		{
			tableauNoms=meilleursJoueurs1;
			tableauScores=meilleursTemps1;
		}
		else if(level==1)
		{
			tableauNoms=meilleursJoueurs2;
			tableauScores=meilleursTemps2;
		}
		else if(level==2)
		{
			tableauNoms=meilleursJoueurs3;
			tableauScores=meilleursTemps3;
		}
		
		if(temps>tableauScores[4])
		{
			Debug.Log("t'es dedans coco!");
		
			tableauScores[4]=temps;
			tableauNoms[4]=name;
			
			float c;
			string d;
			
			for(int i=4;i>0;i--)
			{
				Debug.Log("yeah");
					if(tableauScores[i-1]<tableauScores[i])
					{
						
						c=tableauScores[i];
						d=tableauNoms[i];
					
						tableauScores[i]=tableauScores[i-1];
						tableauNoms[i]=tableauNoms[i-1];
					
						tableauScores[i-1]=c;
						tableauNoms[i-1]=d;
					}
			}
			
		}
		
		//enregistrement des scores dans les playerPrefs
		for(int i=0;i<tableauScores.Length;i++)
		{
			PlayerPrefs.SetFloat("top"+(level+1)+""+i,tableauScores[i]);
			PlayerPrefs.SetString("Nom"+(level+1)+""+i,tableauNoms
				[i]);
		}
		reLaMerde=true;
		
		/*if(GUI.Button(new Rect(505,400,50,50),"ok"))
		{
			level++;
			state="score";
		}*/
	}
}

