//  Author:
//       Sébastien BELLENOUS <sebastien.bellenous@gmail.com>
//  
// 
//  This program is free software: you can redistribute it and/or modify
//  it at your own risk.

using UnityEngine;
using System.Collections;

public class RandomLevelInstantiator : MonoBehaviour {
	public Transform parent;
	public Transform platform;
	
	public int height = 3;
	public int width = 3;
	public float maxDistance = 20.0f;
	public float verticalSpace = 2.0f;
	
	
	// Use this for initialization
	void Start () {
		for(int i = 0 ; i < height ; i++) {
			CreateLevel(i);
		}
		GameController.AddedPlatforms(width*height);
	}
	
	void CreateLevel(int range) {
		int shift = range%2;
		ArrayList clones = new ArrayList();
		float x = 0.0f;
		for(int i = 0 ; i < width-shift ; i++) {
            clones.Add(Instantiate(platform, new Vector3(parent.position.x+maxDistance*x+0.5f*maxDistance*shift, range*verticalSpace+parent.position.y, parent.position.z), Quaternion.identity) as Transform);
            x++;
		}
		foreach (Transform child in clones) {
			int size = Random.Range(1,(int)maxDistance);
			child.localScale = new Vector3(size,child.localScale.y,child.localScale.z);
			child.renderer.material.mainTextureScale = new Vector2(size,child.renderer.material.mainTextureScale.y);
			child.parent = parent;
		}
	}
	
	// Update is called once per frame
	void Update () {
	
	}
}
