// 
//  GameController.cs
//  
//  Author:
//       Sébastien BELLENOUS <sebastien.bellenous@gmail.com>
//  
// 
//  This program is free software: you can redistribute it and/or modify
//  it at your own risk.

using UnityEngine;
using System.Collections;
//using UnityEditor;

public class GameController :  MonoBehaviour{
	public enum State{
		INIT,
		RULES,
		START,
		QUIT,	
		WIN,
		LEVEL_UP,
		LOSE
	};
	
	
	public static readonly float MAX_HEALTH = 100.0f;
	
	public static readonly string SCENE_PATH = "Mario";

	public Transform player;
	public AudioSource startMusic;
	public AudioSource gameMusic;
	public AudioSource gameOverMusic;	
	
	private bool _gameOverPlayed = false;

	private static State _currentState = State.INIT;
	private static Vector3 _playerPosition;
	
	private static bool _cubeMade = false;
	
	//Health
	private static float _health;
	private static bool _hit = false;
	
	private static float _weaponLoad;
	private static float _timerWeapon = 0.0f;
	
	//Score
	private static int _score = 0;
	
	//Level
	private static float max_weapon_load = 100.0f;
	
	private static int _nEnemiesInitial = 0;
	private static int _nEnemiesCurrent = 0;
	private static int _nPlatforms = 0;
	private static int _nPlatformsTreated = 0;	
	private static bool _toInstantiate = false;
	private static int _level = 1;
	private static int _levelUpScore = 0;
	
	// Use this for initialization
	void Start () {
		_nEnemiesInitial = 0;
		_nEnemiesCurrent = 0;
	}
	
	// Update is called once per frame
	void Update () {
		
		switch(_currentState){
		
		case State.INIT:
			_health = MAX_HEALTH;
			_score = 0;
			_level = 1;
			_weaponLoad = max_weapon_load;
			
			if(!startMusic.isPlaying){
				startMusic.Play();
			}
			
			if(gameOverMusic.isPlaying){
				gameOverMusic.Stop();
			}
			
			if(gameMusic.isPlaying){
				gameMusic.Stop();
			}
			
			_gameOverPlayed = false;
			
			
			//EditorApplication.SaveScene(SCENE_PATH,false); //FIXME
			
		break;
			
		case State.START:
			if(_nEnemiesInitial == 0){
				_nEnemiesCurrent = 0;	
			}
			_playerPosition = player.position;
			if(_health <= 0){
				_currentState = State.LOSE;	
			}
			
			if(!gameMusic.isPlaying){
				gameMusic.Play ();
			}
			if(startMusic.isPlaying){
				startMusic.Stop();
			}
			if(_timerWeapon > 0){
				_timerWeapon -= Time.deltaTime;	
			}
			if(_weaponLoad < max_weapon_load && _timerWeapon <= 0.0f){
				_weaponLoad += 5;
			}
			
			if( _nEnemiesCurrent <= 0 ){
				_cubeMade = false;
				_nEnemiesInitial = 0;
				_nPlatformsTreated = 0;	
				_toInstantiate = true;					
			}
			
			if(_level==1 && _nEnemiesInitial != 0){
				_levelUpScore = (int)(0.25f*10.0f*_nEnemiesInitial);
			}
			
			if(_score >= _levelUpScore){
				_level++;
				//_levelUpScore = _levelUpScore * (int)(_level / (_level - 1));
				_levelUpScore = (int)(_levelUpScore * 1.5f);
				_nEnemiesCurrent = 0;
				_nPlatformsTreated = 0;	
				_toInstantiate = true;					
				_currentState = State.LEVEL_UP;
			}
			
			if (_level >= 11){
				_currentState = State.WIN;	
			}
		break;
			
		case State.LEVEL_UP:
			_score = 0;
			_health = MAX_HEALTH;
			_cubeMade = false;
			max_weapon_load = 100.0f - 5.0f*(_level-1);
			_weaponLoad = max_weapon_load;

		break;
			
		case State.LOSE:
			
			if(!gameOverMusic.isPlaying && !_gameOverPlayed){
				gameOverMusic.Play();
				_gameOverPlayed = true;
			}
			if(gameMusic.isPlaying){
				gameMusic.Stop();
			}
			
		break;
			
		case State.QUIT: 
			
			print ("Quit");
			Application.Quit();
			
		break;
		}
	}
	
	public static void SetState(State s){
		_currentState = s;
	}
	
	public static State GetState(){
		return _currentState;
	}
	
	public static Vector3 PlayerPosition(){
		return 	_playerPosition;
	}
	
	public static bool IsHit(){
		return _hit;	
	}
	
	public static bool SetHit(bool hit){
		return _hit = hit;	
	}
	
	public static float GetPercentHealth(){
		return _health/MAX_HEALTH;
	}
	
	public static void RemoveHealth(float health2Remove){
		_health -= health2Remove;
	}
	
	public static int GetScore(){
		return _score;
	}
	
	public static void Gain(int gain){
		_score += gain;
	}
	
	public static void HasShooted(){
		_weaponLoad -= 5 ;
		_timerWeapon = 2.5f;
	}
	
	public static float GetWeaponLoad(){
		return _weaponLoad/max_weapon_load;	
	}
	
	public static int GetLevel(){
		return _level;
	}
	
	public static void NewEnemy(){
		_nEnemiesInitial++;
		_nEnemiesCurrent ++;
		//print ("N = "+_nEnemiesInitial);
	}
	
	public static void EnemyKilled(){
		_nEnemiesCurrent--;
		print ("k = "+_nEnemiesCurrent);
	}
	
	public static bool InstantiateEnemies(){
		return _toInstantiate;
	}
	
	public static void AddedPlatforms(int n){
		_nPlatforms += n;	
		//print ("P = "+_nPlatforms);
	}
	
	public static void PlatformTreated(){
		_nPlatformsTreated++;	
		if(_nPlatformsTreated >= _nPlatforms){
				_toInstantiate = false;	
		}
		//print ("p "+_nPlatformsTreated);
	}
	
	public static float GetLevelUpLoad(){
		return (float)(_score)/_levelUpScore;
	}
	
			
	public static void ResetHealth(){
		_health = MAX_HEALTH;
	}
	
	public static void CubeAdded(){
		_cubeMade = true;
	}
	
	public static bool IsCubeAdded(){
		return _cubeMade;	
	}
}
