//  Author:
//       Sébastien BELLENOUS <sebastien.bellenous@gmail.com>
//  
// 
//  This program is free software: you can redistribute it and/or modify
//  it at your own risk.

using UnityEngine;
using System.Collections;
//using UnityEditor;

public class MainGUI : MonoBehaviour{
	//*********************
	//* PUBLIC PARAMETERS *
	//*********************
	
	//Constants
	public int MAX_HEALTH_POINTS = 5;
	
	//Audio
	
	//Images
	public Texture menuImg;
	public Texture loseImg;
	public Texture winImg;	
	public Texture rulesImg;	
	
	
	public Texture healthPoint;
	public Texture loadTex;	
	public Texture gold;		
	public Texture silver;		
	public Texture copper;			
	public Texture bulletIcon;
	public Texture blood;
	public Texture retry;
	public Texture quit;
	
	//Skins
	public GUISkin menuSkin;
	public GUISkin gameSkin;
	public GUISkin loseSkin;
	public GUISkin RulesSkin;
	
	//*************************
	//* END PUBLIC PARAMETERS *
	//*************************
	
	
	//**********************
	//* PRIVATE PARAMETERS *
	//**********************
	
	//Buttons Parameters
	private int _buttonMenuHeight = 50;
	private int _buttonMenuWidth = 100;
	private int _buttonMenuXOffset = 20;
	
	//Screen scaling
	private int _scalex = 1;
	private int _scaley = 1;
	
	//Textures Parameters
	private int _healthSize = 25;
	private float _bloodTimer = 1.0f;
	private float _levelUpTimer = 0.0f;
	
	//**************************
	//* END PRIVATE PARAMETERS *
	//**************************
	
	// Use this for initialization
	void Start () {
	}
	
	// Update is called once per frame
	void Update () {
		_scalex = (int)(Screen.width/(3*_buttonMenuWidth));
		_scaley = (int)(Screen.height/(2.5*_buttonMenuHeight));
				
		if(_scalex==0){
			_scalex = 1;	
		}
		
		if(_scaley==0){
			_scaley = 1;	
		}
		
//		switch(GameController.GetState()){
//			
//		case GameController.State.INIT:
//			
//		break;
//			
//		case GameController.State.START:
//			
//		break;
//		}
	}
	
	void OnGUI(){	
		//print (GameController.GetState());

		switch(GameController.GetState()){
			
		case GameController.State.INIT:
			menuSkin.button.fontSize = 40*_scalex;

			menuSkin.window.border.left = Screen.width;
			menuSkin.window.border.top = Screen.height;
			
			GUI.skin = menuSkin;
			
			GUI.Window (0,new Rect(0,0,Screen.width,Screen.height),MenuWIndow,"");

		break;
			
		case GameController.State.START:
			GUI.skin = gameSkin;
			GUI.skin.label.fontSize = 50;
			if(GameController.IsHit()){
				_bloodTimer -= Time.deltaTime;
				//GUI.DrawTexture(new Rect(Screen.width/2-20,Screen.height/2,50*_bloodTimer,50*_bloodTimer),blood);	
				GUI.DrawTexture(new Rect(0,0,Screen.width,Screen.height),blood);
			}else{
				_bloodTimer = 1.0f;
			}
			int nHealth = (int)(GameController.GetPercentHealth()*MAX_HEALTH_POINTS);
			for(int i = 0 ; i < nHealth ; i++){
				GUI.DrawTexture(new Rect(i*_healthSize,0,_healthSize,_healthSize),healthPoint);
			}
			int levelUpLoad = (int)(GameController.GetLevelUpLoad()*450);

			GUI.DrawTexture(new Rect(Screen.width-450,0,levelUpLoad,60), loadTex);
			
			GUI.skin.label.alignment = TextAnchor.MiddleLeft;
			GUI.Label(new Rect(Screen.width-450,0,300,60), "Level "+GameController.GetLevel().ToString());	
			GUI.skin.label.alignment = TextAnchor.MiddleRight;
			GUI.Label(new Rect(Screen.width-150,0,150,60), GameController.GetScore().ToString());
			
			//Weapon Load
			GUI.DrawTexture(new Rect(0,Screen.height-220,20,200), gameSkin.label.normal.background);			
			GUI.DrawTexture(new Rect(0,Screen.height-15,20,15), bulletIcon);
			int weaponLoadTexHeight = (int)(GameController.GetWeaponLoad()*200);
			GUI.DrawTexture(new Rect(0,Screen.height-weaponLoadTexHeight-20,20,weaponLoadTexHeight), loadTex);
			
		break;
			
		case GameController.State.LEVEL_UP:
			GUI.skin = gameSkin;
			if(_levelUpTimer < 2.0f){
				GUI.skin.label.alignment = TextAnchor.MiddleCenter;
				//print (GUI.skin.label.fontSize);
				GUI.skin.label.fontSize += (int)_levelUpTimer%2;
				GUI.Label(new Rect(0,0,Screen.width,Screen.height), "Level "+GameController.GetLevel().ToString());
				_levelUpTimer += Time.deltaTime;
			}else{
				GUI.skin.label.fontSize = 50;
				_levelUpTimer = 0.0f;
				GameController.SetState(GameController.State.START);
			}
			
		break;
			
		case GameController.State.LOSE:
			GUI.skin = loseSkin;
			GUI.Window (1,new Rect(0,0,Screen.width,Screen.height),LoseWindow,"");
		break;
			
		case GameController.State.WIN:
			GUI.skin = loseSkin;
			GUI.Window (3,new Rect(0,0,Screen.width,Screen.height),WinWindow,"");
		break;
			
			
		case GameController.State.RULES:
			GUI.skin = RulesSkin;
			GUI.Window (2,new Rect(0,0,Screen.width,Screen.height),RulesWindow,"");
		break;
		}
	}
	
	void RulesWindow(int windowID){
		GUI.DrawTexture(new Rect(0,0,Screen.width,Screen.height),rulesImg);
		GUI.Label(new Rect(0, 0, Screen.width, Screen.height),"                                                   RULES \n \n Beware ! Mario is armed and dangerous ! \n Use your mouse to aim and shoot the evil goombas. \n Press A & D to move and Space to jump \n Each kill rewards you with points to gain levels \n Reach the highest level you can ! \n But be carefull with your life points, \n GlaDOS is watching you ! ");
		if(GUI.Button(
			new Rect(10,Screen.height-60,100,50), 
			"Back")){
			GameController.SetState(GameController.State.INIT);
		}
	}
	
	void MenuWIndow(int windowID){
		int bgWidth = (int) _scalex*10*900/100;
		int bgHeight = (int) _scaley*10*1348/100;
		GUI.DrawTexture(new Rect((Screen.width-bgWidth)/2,(Screen.height-bgHeight)/2,bgWidth,bgHeight),menuImg);
		
		int buttonMenuY = (Screen.height-_buttonMenuHeight*_scaley)/2;
			
		if(GUI.Button(
			new Rect(_buttonMenuXOffset*_scalex,buttonMenuY,_buttonMenuWidth*_scalex,_buttonMenuHeight*_scaley), 
			"Start")){
			GameController.SetState(GameController.State.START);
		}
		
		if(GUI.Button(
			new Rect(Screen.width-_buttonMenuWidth*_scalex-_buttonMenuXOffset*_scalex,buttonMenuY,_buttonMenuWidth*_scalex,_buttonMenuHeight*_scaley), 
			"Quit")){
			GameController.SetState(GameController.State.QUIT);
		}
		
		if(GUI.Button(
			new Rect(Screen.width/2-_buttonMenuWidth*_scalex/2.4f,2*buttonMenuY,_buttonMenuWidth*_scalex/1.2f,_buttonMenuHeight*_scaley/1.2f), 
			"Rules")){
			GameController.SetState(GameController.State.RULES);
		}
	}
	
	
	void LoseWindow(int windowID){
		float loseScale = (float)Screen.width/loseImg.width;
		int loseHeight = (int) (loseScale*loseImg.height);
		GUI.DrawTexture(new Rect(0,Screen.height-loseHeight,Screen.width,loseHeight),loseImg);	
		GUI.skin.label.fontSize = 50;
		GUI.Label(new Rect(50,10,Screen.width-50,Screen.height-10),
			"Game Over");
		GUI.skin.label.fontSize = 30;
		//GUI.Label(new Rect(50,100,500,100),"Your Score is "+GameController.GetScore());
		
		if(GameController.GetLevelUpLoad() >= 0.25f && GameController.GetLevelUpLoad() < 0.5f){
			GUI.DrawTexture(new Rect(250,10,100,125),copper);
		}
		
		if(GameController.GetLevelUpLoad() >= 0.5f && GameController.GetLevelUpLoad() < 0.75f){
			GUI.DrawTexture(new Rect(250,10,100,125),silver);
		}		
		
		if(GameController.GetLevelUpLoad() >= 0.75f && GameController.GetLevelUpLoad() < 1.0f){
				GUI.DrawTexture(new Rect(250,10,100,125),gold);
		}
		GUI.Label(new Rect(265,130,Screen.width,Screen.height),"Level "+GameController.GetLevel());
		
		//GUI.Label(new Rect(50,10,Screen.width,Screen.height),"Your Score is "+GameController.GetScore());
		if(GUI.Button(new Rect(Screen.width-100,0,100,100),retry)){
			
			/*
			
 			string sceneName = EditorApplication.currentScene;		
			Debug.Log (EditorApplication.currentScene);
			EditorApplication.isPaused = false;
	        EditorApplication.isPlaying = false;
	        
	        FileUtil.DeleteFileOrDirectory(EditorApplication.currentScene);
	        FileUtil.MoveFileOrDirectory(GameController.SCENE_PATH, sceneName);
	        FileUtil.DeleteFileOrDirectory(GameController.SCENE_PATH);
			
	        EditorApplication.OpenScene(sceneName);
	        
	        */ //FIXME
			

			Application.LoadLevel(GameController.SCENE_PATH);
			GameController.SetState(GameController.State.INIT);
		}
		if(GUI.Button(new Rect(Screen.width-100,Screen.height-100,100,100),quit)){
			GameController.SetState(GameController.State.QUIT);
		}
	}
	
	void WinWindow(int windowID){
		GUI.skin.label.fontSize = 60;
		GUI.DrawTexture(new Rect(0,0,Screen.width,Screen.height),winImg);
		GUI.Label(new Rect(0,0,Screen.width,Screen.height),"Congratulations !");
		if(GUI.Button(new Rect(Screen.width-100,Screen.height-100,100,100),quit)){
			GameController.SetState(GameController.State.QUIT);
		}
	}
}
