//  Author:
//       Sébastien BELLENOUS <sebastien.bellenous@gmail.com>
//  
// 
//  This program is free software: you can redistribute it and/or modify
//  it at your own risk.

using UnityEngine;
using System.Collections;

public class Goomba : MonoBehaviour {
	public AudioSource helloSound;
	
	private float randomDistance;
	private float randomSpeed;
	private int randomPhase;
	private bool isWalking = false;
	
	float _soundTimer = 0.0f;
	// Use this for initialization
	void Start () {
		//randomDistance = Random.Range(2,(int)(0.5f*transform.parent.localScale.x));
		randomDistance = 0.1f*transform.parent.localScale.x*Random.Range(2,3);
		//print(randomDistance);
		randomSpeed = 0.1f*Random.Range(20,40);
		randomPhase = Random.Range(0,2);
	}
	
	// Update is called once per frame
	void Update () {
		
		if(GameController.GetState() == GameController.State.START && 
			isWalking == false && transform.parent != null 
			&& (GameController.PlayerPosition()-transform.parent.position).magnitude < 5){
		
			isWalking = true;
		}
		
		if(GameController.GetState() == GameController.State.START && 
			(GameController.PlayerPosition()-transform.position).magnitude < 5 && 
			Time.time > _soundTimer){
				helloSound.Play();
				_soundTimer = Time.time + 5.0f;
		}
		if(GameController.GetState() == GameController.State.START && isWalking){
			//float distance = transform.parent.localScale.x - ((int)(transform.parent.localScale.x/3) - 1);
			//int randomDistance = Random.Range(1,9);
			//int randomSpeed = Random.Range(1,11);
			transform.Translate(0.01f*randomDistance*Mathf.Cos(0.1f*randomSpeed*Mathf.PI*Time.time+randomPhase*Mathf.PI)*Vector3.right);
			int t = (int) (Time.time*0.8*randomSpeed)%2;
			if(t==0){
				t = -1;	
			}
			transform.renderer.material.mainTextureScale = new Vector2(t,-1);
		}
		if(transform.position.y < -100){
			Destroy(gameObject);
		}
	}

	void OnCollisionEnter(Collision collision) {
		if(collision.gameObject.CompareTag("Bullet")){
			if(audio){
				audio.Play();
				helloSound.Stop();
			}
			//rigidbody.AddForce(100*rigidbody.mass*Vector3.up);
			gameObject.collider.enabled = false;
			GameController.EnemyKilled();
			GameController.Gain(10);
		}
	}
}
