//  Author:
//       Sébastien BELLENOUS <sebastien.bellenous@gmail.com>
//  
// 
//  This program is free software: you can redistribute it and/or modify
//  it at your own risk.

using UnityEngine;
using System.Collections;

public class FightController : MonoBehaviour {
	public float HIT_DELAY = 3.0f;
	public AudioSource hitSound;
	
	private float _timer = 0.0f;
		
	// Use this for initialization
	void Start () {
		
	}
	
	// Update is called once per frame
	void Update () {
		if(Time.time > _timer ){
			GameController.SetHit(false);
		}
	}
	
     void OnControllerColliderHit(ControllerColliderHit hit) {
		switch(hit.gameObject.tag){
		case "Goomba":
			ApplyPercentDamage(0.2f);
		break;

		case "PiranhaPlant":
			ApplyPercentDamage(0.2f);
		break;
		}
	}
	
    void OnTriggerEnter(Collider other) {
		switch(other.gameObject.tag){
		case "Fireball":
			ApplyPercentDamage(0.4f);
		break;
		}
    }
	
	
	public void ApplyPercentDamage(float percent){
		if(GameController.GetState() == GameController.State.START && Time.time > _timer){
			hitSound.Play();
			GameController.RemoveHealth(percent*GameController.MAX_HEALTH);
			_timer = Time.time + HIT_DELAY;
			GameController.SetHit(true);
		}
	}
}
